% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisgamp.r
\name{poisgamp}
\alias{poisgamp}
\title{Poisson sampling with a gamma prior}
\usage{
poisgamp(y, shape, rate = 1, scale = 1/rate, alpha = 0.05, plot = TRUE,
  suppressOutput = FALSE)
}
\arguments{
\item{y}{a random sample from a Poisson distribution.}

\item{shape}{the shape parameter of the \eqn{gamma} prior.}

\item{rate}{the rate parameter of the \eqn{gamma} prior. Note that the scale
is \eqn{1 / rate}}

\item{scale}{the scale parameter of the \eqn{gamma} prior}

\item{alpha}{the width of the credible interval is controlled by the
parameter alpha.}

\item{plot}{if \code{TRUE} then a plot showing the prior and the posterior
will be produced.}

\item{suppressOutput}{if \code{TRUE} then none of the output is printed to
console}
}
\value{
An object of class 'Bolstad' is returned. This is a list with the
following components:

\item{prior}{the prior density assigned to \eqn{\mu}{mu}}
\item{likelihood}{the scaled likelihood function for \eqn{\mu}{mu} given
\eqn{y}} \item{posterior}{the posterior probability of \eqn{\mu}{mu} given
\eqn{y}} \item{shape}{the shape parameter for the \eqn{gamma} posterior}
\item{rate}{the rate parameter for the \eqn{gamma} posterior}
}
\description{
Evaluates and plots the posterior density for \eqn{\mu}{mu}, the mean rate
of occurance in a Poisson process and a \eqn{gamma} prior on \eqn{\mu}{mu}
}
\examples{

## simplest call with an observation of 4 and a gamma(1,1), i.e. an exponential prior on the
## mu
poisgamp(4,1,1)

##  Same as the previous example but a gamma(10,1) prior
poisgamp(4,10,1)

##  Same as the previous example but an improper gamma(1,0) prior
poisgamp(4,1,0)

## A random sample of 50 observations from a Poisson distribution with
## parameter mu = 3 and  gamma(6,3) prior
y = rpois(50,3)
poisgamp(y,6,3)

## In this example we have a random sample from a Poisson distribution
## with an unknown mean. We will use a gamma(6,3) prior to obtain the
## posterior gamma distribution, and use the R function qgamma to get a
## 95\% credible interval for mu
y = c(3,4,4,3,3,4,2,3,1,7)
results = poisgamp(y,6,3)
ci = qgamma(c(0.025,0.975),results$shape, results$rate)
cat(paste("95\% credible interval for mu: [",round(ci[1],3), ",", round(ci[2],3)),"]\\n")

## In this example we have a random sample from a Poisson distribution
## with an unknown mean. We will use a gamma(6,3) prior to obtain the
## posterior gamma distribution, and use the R function qgamma to get a
## 95\% credible interval for mu
y = c(3,4,4,3,3,4,2,3,1,7)
results = poisgamp(y, 6, 3)
ci = quantile(results, c(0.025, 0.975))
cat(paste("95\% credible interval for mu: [",round(ci[1],3), ",", round(ci[2],3)),"]\\n")


}
\seealso{
\code{\link{poisdp}} \code{\link{poisgcp}}
}
\keyword{misc}
