% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blanket_statsments.R
\name{blanket_redundancy_analysis}
\alias{blanket_redundancy_analysis}
\title{Blanket redundancy analysis}
\usage{
blanket_redundancy_analysis(
  model_list,
  data,
  r2_threshold = 0.9,
  nk = 0,
  verbose = FALSE
)
}
\arguments{
\item{model_list}{a list of statistical regression model of class linear, logistic or coxph}

\item{data}{data.frame used to create the models}

\item{r2_threshold}{float threshold value to consider a parameter redundant}

\item{nk}{number of knots in splicing}

\item{verbose}{ctivate printouts of key findings}
}
\value{
an list of objects of class "redun"
}
\description{
Perform a blanket redundancy analysis on a list of existing models
}
\examples{
data <- survival::lung
models_to_run <- list(
'OS' = list('outcome' = 'time', 'modality' = 'cox', 'event_censor' = 'status'),
'weight_loss' = list('outcome' = 'wt.loss', 'modality' = 'linear', 'event_censor' = NA))
predictor_sets <- list('age' = c('age'), 'age_ecog' = c('age', 'ph.ecog'))
covariates = c('sex')
bl_stats <- blanket_statsments(data, models_to_run, predictor_sets, covariates)
blanket_redundancy_analysis(bl_stats, data)

}
\seealso{
[blanket_stats()]
}
\author{
J. Peter Marquardt
}
