% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEFR.R
\docType{data}
\name{bland.altman.PEFR}
\alias{bland.altman.PEFR}
\title{PEFR Data from Bland JM and Altman DG 1986}
\format{An object of class \code{data.frame} with 17 rows and 4 columns.}
\usage{
bland.altman.PEFR
}
\description{
Peak expiratory flow data from 17 members of Bland's family, taken with two 
different instruments, each twice. This data is for explanatory use only.
Columns 1 and 2 were measured with the "Wright" peak flow meter, columns 3
and 4 with the "Mini Wright" peak flow meter. 
These are the data behind fig. 1, fig. 2 and fig. 6 of the original paper and
these can be easily reconstructed
}
\examples{
# this is what fig. 1. would have looked like in R:
x <- bland.altman.PEFR[["bigger.first"]]
y <- bland.altman.PEFR[["smaller.first"]]
plot(x,y, xlab="PEFR by large meter",ylab="PEFR by mini meter", 
     xlim=c(0,800), ylim=c(0,800))
abline(0,1)
}
\keyword{datasets}

