% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulacro.R
\name{simulacro}
\alias{simulacro}
\title{Builds a simulated biological invasion dataset.}
\usage{
simulacro(INIDIST, YEARS, BOUNDARY, NNAT, NANTH, A, C = 2, X, HSM = FALSE,
  FACANTH = 1, FACNAT = 1, ITERATIONS = 1, DIR = F,
  TRUEANTH = c(FALSE, TRUE), TRUEDB, PROB = 0.5)
}
\arguments{
\item{INIDIST}{data frame of initial distribution. Columns must be: 'year' (year of first sighting); 'y' (latitude on a projected coordinate system with meters as distance unit of measure); 'x' (longitude on a projected coordinate system with meters as distance unit of measure); 'species' (the name of the species for that sighting location); 'Pnat' ([0;1], probability for that sighting location of being of natural origin (as computed by function EM())), 'Dist' (dispersal distance of that sighting location as computed by function EM()).}

\item{YEARS}{vector of unique year values for which the simulacro function will generate data (they will be written in the output file).}

\item{BOUNDARY}{object of class sp::SpatialPolygons or raster:RasterLayer (0: inside, >= 1: outside) used as geographi boundary for function RPG(). These are the geographic limits within which points or anthropic origin can be generated.}

\item{NNAT}{either a vector of numbers of natural points to be generated every year  or an integer number of points to be generated per time-step.}

\item{NANTH}{either a vector of numbers of anthropic points to be generated every year or an integer number of points to be generated per time-step.}

\item{A}{Alpha values for the one dimensional dispersal kernel. Each Alpha value will be used to generate a single data frame.}

\item{C}{C values for the one dimensional dispersal kernel. C=2: normal kernel; C=1: negative exponenetial kernel; C<1: fat-tailed kernel.}

\item{X}{set of possible interpopulation distances [km].}

\item{HSM}{either a Habitat Suitability Map ([0;1], object of class raster::RasterLayer, probability raster giving value of likelyhood of a viable population establishing each cell) or the geographic boundaries (object of class sp::SpatialPolygons) within which to generate points of natural or anthropic origin.}

\item{FACANTH}{Only if HSM is a probability raster. Factor multiplying NANTH before the filtering. This value should be high if HSM has a low proportion of suitable cells.}

\item{FACNAT}{Only if HSM is a probability raster. Factor multiplying NNAT before the filtering}

\item{ITERATIONS}{number of replicate datasets generated with the same Alpha and C values.}

\item{DIR}{directory where to write the simulated datasets. if FALSE they will be saved as data frames in a list object.}

\item{TRUEANTH}{If FALSE will use HSM to simulate anthropogenic dispersal. If TRUE will use TRUEDB}

\item{TRUEDB}{data frame containing points of anthropic origin (must be in the same format as INIDIST, rows where TRUEDB$Pnat>PROB will be ignored). Ignored if TRUEANTH= FALSE, but HSM must then be specified.}

\item{PROB}{threshold over which Pnat is considered natural.}
}
\value{
list of data frames. Every data frame represents a simulated biological invasion. if DIR=TRUE one folder will be created for each Alpha and C combination containig all the replicates datasets set in ITERATION. if DIR=FALSE (default) the order in the list will follow the order of the C and Alpha values respectively as set in C and A.
}
\description{
This function builds point time seris within geographic borders based on an iterative process that simulates biological invasions. Points of natural and anthropic origin can be generated with different processes. Points of natural origin are generated by a stepwise process where new locatins are chosen on the basis of a user-definable dispersal kernel. Points of antrhopic origin are sampled randomly. All generated points can be filtered through probability maps.
}
\examples{
data('frogsEM')  #see example in ?EM().
data('nzp')

idst<- frogsEM[1:10,]
Cr<- frogsEM[-(1:10),]
yr<- unique(Cr$year)

nNoYear<- rep(NA,length(unique(Cr$year)))
hNoYear<- rep(NA,length(unique(Cr$year)))

for(i in 1:length(unique(Cr$year))){
 CrYear<- Cr[Cr$year==unique(Cr$year)[i],]  #Cr for that year
 nNoYear[i]<- nrow(CrYear[CrYear$Pnat>=.5,])  #natural points for that year
 hNoYear[i]<- nrow(CrYear[CrYear$Pnat<.5,])  #human points for that year
}

AV<- c(2,3,4.5,7.5,11,15,20,25)  #alpha values

\dontrun{
frogsLacro<- simulacro(INIDIST=idst,YEARS=yr,
 BOUNDARY=nzp,NNAT=nNoYear,NANTH=hNoYear,
 FACNAT=10,
 A=AV,X=seq(.1,30,.1),
 TRUEANTH=TRUE,TRUEDB=Cr,PROB=.5,
 ITERATIONS=10,HSM=nzp)
 }
}
\author{
Luca Butikofer
}

