% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotlacro.R
\name{plotlacro}
\alias{plotlacro}
\title{Plots the file type used as input and output of simulacro().}
\usage{
plotlacro(x, tr = 0.5, outline, main = "std")
}
\arguments{
\item{x}{simulacro-type file (as outputted by simulacro() or inputted as argument INIDIST).}

\item{tr}{threshold for Pnat above which points are considered of human nature.}

\item{outline}{geographical boundaries to x. Object of class sp::SpatialPolygons or data frame or matrix with the outline's corners.}

\item{main}{main title of the plot, by default is 'Map of ...' where ...= x$species (the name of the modelled species).}
}
\value{
plot.
}
\description{
This function makes a plot of the data frame used for argument INIDIST of function simulacro() and of the output of simulacro(). The plot shows the points as circles and crosses to represent their natural and anthropic origin respectively and has an iformative legend.
}
\examples{
data(frogsEM)
plotlacro(x= frogsEM, outline= nzp)
}
\author{
Luca Butikofer
}

