\name{gg_qqplot}
\alias{gg_qqplot}
\title{
Graphique des quantiles (qqplot) et droite interquartile
}
\description{
Dessine le graphique des quantiles ou \code{\link{qqplot}} et la droite interquartile (passant par le premier et le troisième quartile à la manière de la fonction \code{\link{qqline}}) avec la bibliothèque graphique \code{ggplot2}.
}
\usage{
gg_qqplot(df,var,qdist=qnorm,params=list(),qq.line=TRUE,color="red",alpha=.5) 
}
\arguments{
  \item{df}{Un jeu de données (dataframe)}
  \item{var}{Le nom d'une variable de df}
  \item{qdist}{La fonction quantile d'une (famille de) distribution. Par défaut celle de la famille des lois normales.}
  \item{params}{Une liste de paramètres pour spécifier la loi à utiliser. Par défaut la loi normale centrée et réduite. Les paramètres peuvent être estimés avec la fonction \code{\link[MASS]{fitdistr}} de la bibliothèque MASS.}
  \item{qq.line}{Une valeur logique. Affiche ou masque la droite interquartile.}
  \item{color}{Le nom d'une couleur. Spécifie la couleur à utiliser pour la droite interquartile.}
  \item{alpha}{Indice de transparence. Spécifie la transparence à utiliser pour représenter les valeurs de l'échantillon.}
}
\value{
\item{ggplot}{Un graphique utilisant la bibliothèque ggplot2. Affiche les valeurs des quartiles théoriques par lesquels passe la droite ainsi que son ordonnée à l'origine et sa pente si le tracé de celle-ci est demandé.}
}
\references{F. Bertrand, M. Maumy-Bertrand, Initiation à la Statistique avec R, Dunod, 2e, 2014.}
\author{\enc{Frédéric}{Fr\'ed\'eric} Bertrand\cr
\email{frederic.bertrand@math.unistra.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
\enc{Myriam}{Myriam} Maumy-Bertrand\cr
\email{myriam.maumy@math.unistra.fr}\cr
\url{http://www-irma.u-strasbg.fr/~mmaumy/}
}
\seealso{\code{\link{qqplot}}, \code{\link{qqline}}}
\examples{
glycine.blanche<-subset(Mesures,subset=(Mesures$espece=="glycine blanche"))
gg_qqplot(glycine.blanche,"taille")

#bonus ajustement avec une autre loi (ici Student (car dist = qt) dont on estime les ddl)
lauriers.roses<-subset(Mesures,subset=(Mesures$espece=="laurier rose"))
shapiro.test(lauriers.roses$taille) 
#pas issu d'une loi normale au risque alpha=5%
gg_qqplot(lauriers.roses,"taille")
gg_qqplot(lauriers.roses,"taille",qq.line=FALSE)
#essayons un qqplot avec une loi de Student
\dontrun{
require(MASS)
params <- as.list(fitdistr(lauriers.roses$taille, "t")$estimate)
#avec la droite
gg_qqplot(lauriers.roses,"taille",qt,params)
#essayons un qqplot avec une loi gamma
params <- as.list(fitdistr(lauriers.roses$taille,"gamma")$estimate)
#avec la droite
gg_qqplot(lauriers.roses,"taille",qgamma,params)
#essayons un qqplot avec une loi du chi-deux
params <- list(df=fitdistr(lauriers.roses$taille,"chi-squared",start=list(df=5),
method="Brent",lower=1,upper=40)$estimate)
#avec la droite
gg_qqplot(lauriers.roses,"taille",qchisq,params)
}
}
\keyword{univar}
