% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVARObjectClass.R
\docType{class}
\name{BigVAR.results}
\alias{BigVAR.results}
\alias{BigVAR.results-class}
\title{BigVAR.results
This class contains the results from cv.BigVAR.}
\description{
It inherits the class BigVAR, but contains substantially more information.
}
\section{Fields}{

\describe{
\item{\code{InSampMSFE}}{In-sample MSFE from optimal value of lambda}

\item{\code{LambdaGrid}}{Grid of candidate lambda values}

\item{\code{index}}{Rank of optimal lambda value}

\item{\code{OptimalLambda}}{Value of lambda that minimizes MSFE}

\item{\code{OOSMSFE}}{Average Out of sample MSFE of BigVAR model with optimal lambda}

\item{\code{seoosfmsfe}}{Standard error of out of sample MSFE of BigVAR model with optimal lambda}

\item{\code{MeanMSFE}}{Average out of sample MSFE of unconditional mean forecast}

\item{\code{MeanSD}}{Standard error of out of sample MSFE of unconditional mean forecast}

\item{\code{MeanPreds}}{predictions from conditional mean model}

\item{\code{RWMSFE}}{Average out of sample MSFE of random walk forecast}

\item{\code{RWPreds}}{Predictions from random walk model}

\item{\code{RWSD}}{Standard error of out of sample MSFE of random walk forecast}

\item{\code{AICMSFE}}{Average out of sample MSFE of AIC forecast}

\item{\code{AICSD}}{Standard error of out of sample MSFE of AIC forecast}

\item{\code{AICPreds}}{Predictions from AIC VAR/VARX model}

\item{\code{AICpvec}}{Lag orders selected from AIC VAR model}

\item{\code{AICpvec}}{Lag orders selected from AIC VARX model}

\item{\code{BICMSFE}}{Average out of sample MSFE of BIC forecast}

\item{\code{BICSD}}{Standard error of out of sample MSFE of BIC forecast}

\item{\code{BICPreds}}{Predictions from BIC VAR/VARX model}

\item{\code{BICpvec}}{Lag orders selected from BIC VAR model}

\item{\code{BICpvec}}{Lag orders selected from BIC VARX model}

\item{\code{betaPred}}{The final estimated \eqn{k\times kp+ms+1} coefficient matrix, to be used for prediction}

\item{\code{Zvals}}{The final lagged values of \code{Y}, to be used for prediction}

\item{\code{fitted}}{fitted values obtained from betaPred}

\item{\code{resids}}{residuals obtained from betaPred}

\item{\code{Data}}{a \eqn{T \times k} or \eqn{T\times k + m} multivariate time Series}

\item{\code{lagmax}}{Maximal lag order}

\item{\code{Structure}}{Penalty structure}

\item{\code{Relaxed}}{Indicator for relaxed VAR}

\item{\code{Granularity}}{Granularity of penalty grid}

\item{\code{horizon}}{Desired forecast horizon}

\item{\code{crossval}}{Cross-Validation procedure}

\item{\code{alpha}}{additional penalty parameter for Sparse Lag Group or Sparse Own/Other methods. Will contain either the heuristic choice of \eqn{1/(k+1)} or the value selected by cross validation if the argument \code{dual} is set to \code{TRUE}}

\item{\code{VARXI}}{VARX Indicator}

\item{\code{Minnesota}}{Minnesota Prior Indicator}

\item{\code{verbose}}{verbose indicator}

\item{\code{dual}}{indicator as to whether dual cross validation was conducted}

\item{\code{contemp}}{indicator if contemporaneous exogenous predictors are used}

\item{\code{lagmatrix}}{matrix of lagged values used to compute residuals (of which Zvals is the final column)}

\item{\code{betaArray}}{array of VAR/VARX coefficients from out of sample forecasts}

\item{\code{sparse_count}}{average fraction of active coefficients in validation period}

\item{\code{lambda_evolve_path}}{evolution of lambda over evaluation period}
}}

\note{
One can also access any object of class BigVAR from BigVAR.results
}
\author{
Will Nicholson
}
