% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdCrossprod.R
\name{bdCrossprod}
\alias{bdCrossprod}
\title{Crossproduct  of DelayedArray}
\usage{
bdCrossprod(A, B = NULL, block_size = 256, paral = TRUE, threads = NULL)
}
\arguments{
\item{A}{numerical or Delayed Array matrix}

\item{B}{optional, numerical or Delayed Array matrix}

\item{block_size}{(optional, defalut = 128) block size to make matrix multiplication, if `block_size = 1` no block size is applied (size 1 = 1 element per block)}

\item{paral, }{(optional, default = TRUE) if paral = TRUE performs parallel computation else performs seria computation}

\item{threads}{(optional) only if bparal = true, number of concurrent threads in parallelization if threads is null then threads =  maximum number of threads available}
}
\value{
numerical matrix with crossproduct
}
\description{
This function performs a crossproduct or transposed crossproduct of numerical or DelayedArray matrix.
}
\examples{

library(DelayedArray)

n <- 100
p <- 60

X <- matrix(rnorm(n*p), nrow=n, ncol=p)

# without DelayedArray
bdCrossprod(X)

# with DelayedArray
XD <- DelayedArray(X)
bdCrossprod(XD)

all.equal(crossprod(X), bdCrossprod(X))


n <- 100
p <- 100

Y <- matrix(rnorm(n*p), nrow=n)

# without DelayedArray
bdCrossprod(X,Y)

}
