% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamplot.R
\name{beamplot}
\alias{beamplot}
\title{Create a beamplot using raw citations from a WoS download}
\usage{
beamplot(wos_file, do_weight = FALSE, ...)
}
\arguments{
\item{wos_file}{is the file name of the downloaded WoS export in the format Tab-delimited (Win, UTF-8).}

\item{do_weight}{is a boolean to spcify if citation counts should be weighted with their age. The older the publication, the smaller the weight. The weight depends on on the difference between the year until that citations are counted (i.e., the current calendar year in the case of WoS downloads) and the publication year. A weighting factor of 1 is used for a difference of 0, 1/2 for a difference of 1, ..., and 1/11 for differences of ten or more.}

\item{...}{further parameters passed to stripchart.}
}
\description{
Create a beamplot using raw citations from a WoS download. Use the format
"Other File Format --> Tab-delimited (Win, UTF-8)" and provide the downloaded file name.
a simple weighting of citation counts is also available for comparison of older with newer publications.
}
\details{
beamplot(wos_file="WoS_savedrecs.txt", do_weight=boolean)
Only the argument wos_file is mandatory. The argument do_weight is optional and FALSE by default.

Literature:

- Haunschild, R., Bornmann, L., & Adams, J. (2019). R package for producing beamplots as a preferred alternative to the h index when assessing single researchers (based on downloads from Web of Science), Scientometrics, DOI 10.1007/s11192-019-03147-3, preprint: https://arxiv.org/abs/1905.09095
}
\examples{

\dontrun{beamplot("WoS_savedrecs.txt")}

}
