% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Difference-Against-Mean-Bib-plot_base_graphics.R
\name{DAMBibPlot}
\alias{DAMBibPlot}
\title{Create a difference against mean plot using journal and paper percentile values}
\usage{
DAMBibPlot(df, off_set = 0, print_stats = TRUE, do_plot = TRUE,
  digits = 1, ...)
}
\arguments{
\item{df}{data frame with journal and paper percentiles}

\item{off_set}{determines the location of additional plotted information (number of points in each
quadrant), values between 0 and 40 might be useful (optional parameter). The default value is 0.}

\item{print_stats}{boolean variable (optional parameter) which determines if the additional statistical values are printed
to the R console (T: yes print, F: no do not print). The default value is T.}

\item{do_plot}{boolean variable (optional parameter) which determines if the difference against mean plot is actually produced
(T: yes plot, F: no do not plot). The default value is T.}

\item{digits}{integer value to determine the number of desired digits after the decimal point for statistical values (optional parameter). The default value is 1.}

\item{...}{additional arguments to pass to the \link{plot} function}
}
\description{
Provide journal and paper percentile values in a data frame, e.g. df,
and the function call DAMBibPlot(df) creates the difference against mean plot.
DAMBibPlot takes some optional arguments to modify its behaviour, see arguments and details.
}
\details{
DAMBibPlot(df=data_frame, off_set=numeric_value, print_stats=boolean, do_plot=boolean)
Only the argument df is necessary. All other aruments are optional.

Literature:

- Bland, J. M., & Altman, D. G. (1986). Statistical Methods for Assessing Agreement between Two Methods of Clinical Measurement. Lancet, 1(8476), 307-310, https://www.ncbi.nlm.nih.gov/pubmed/2868172

Cleveland, W. S. (1985). The elements of graphing data. Monterey, CA: Wadsworth Advanced Books and Software.

- Bornmann, L., & Haunschild, R. (2017). Plots for visualizing paper impact and journal impact of single researchers in a single graph, DOI: 10.1007/s11192-018-2658-1, preprint: https://arxiv.org/abs/1707.04050


An example data frame is provided as \code{example_researcher} in the package. It can be used to create a difference against mean plot using default values.
}
\examples{
data(example_researcher)

DAMBibPlot(example_researcher)
}

