% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{getRuntime}
\alias{getRuntime}
\title{Extracting runtime}
\usage{
getRuntime(x, which = 0)
}
\arguments{
\item{x}{object of class 'orderMCMC'or 'partitionMCMC'}

\item{which}{integer, defines if the runtime is extracted for: computing score tables (which = 1), running MCMC chain (which = 2)}
}
\value{
runtime of a particular step of MCMC scheme or total runtime
}
\description{
This function extracts runtime of a particular step of order and partition MCMC.
}
\examples{
myscore<-scoreparameters("bge",Boston)
\dontrun{
orderfit<-sampleBN(myscore,algorithm="order")
(getRuntime(orderfit,1))
(getRuntime(orderfit,2))
}
}
