% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{string2mat}
\alias{string2mat}
\title{Deriving interactions matrix}
\usage{
string2mat(curnames, int, mapping = NULL, type = c("int"), pf = 2)
}
\arguments{
\item{curnames}{character vector with gene names which will be used in \code{BiDAG} learning function}

\item{int}{data frame, representing a interactions between genes/proteins downloaded from STRING (\url{https://string-db.org/}); two columns are necessary 'node1' and 'node2'}

\item{mapping}{(optional) data frame, representing a mapping between 'curnames' (gene names, usually the column names of 'data') and gene names used in interactions downloaded from STRING (\url{https://string-db.org/}); two columns are necessary 'queryItem' and 'preferredName'}

\item{type}{character, defines how interactions will be reflected in the output matrix; \code{int} will result in a matrix whose entries equal 1 if interaction is present in the list of interactions \code{int} and 0 otherwise; \code{blacklist} results in a matrix whose entries equal 0 when interaction is present in the list of interactions and 1 otherwise;
\code{pf} results in a matrix results in a matrix whose entries equal 1 is interaction is present in the list of interactions \code{int} and \code{pf} otherwise$ "int" by default}

\item{pf}{penalization factor for interactions, needed if \code{type}=pf}
}
\value{
square matrix whose entries  correspond to the list of interactions and parameter \code{type}
}
\description{
This transforms a list of possible interactions between proteins downloaded from STRING database
into a matrix which can be used for blacklisting/penalization in BiDAG.
}
\examples{
curnames<-colnames(kirp)
intmat<-string2mat(curnames, mapping, interactions, type="pf")
}
