% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphhelpfns.R
\name{connectedSubGraph}
\alias{connectedSubGraph}
\title{Deriving connected subgraph}
\usage{
connectedSubGraph(adj)
}
\arguments{
\item{adj}{square adjacency matrix with elements in \code{\{0,1\}}, representing a graph}
}
\value{
adjacency matrix of a subgraph of graph represented by 'adj' whose nodes have at least one connection
}
\description{
This function derives an adjacency matrix of a subgraph whose nodes are connected to at least one other node in a graph
}
\examples{
dim(gsimmat) #full graph contains 100 nodes
gconn<-connectedSubGraph(gsimmat) #removing disconnected nodes
dim(gconn) #connected subgraph contains 93 nodes
}
