% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotusingrgraphviz.R
\name{plotdiffsDBN}
\alias{plotdiffsDBN}
\title{Plotting difference between two DBNs}
\usage{
plotdiffsDBN(
  eDBN,
  trueDBN,
  struct = c("init", "trans"),
  b = 0,
  showcl = TRUE,
  ...
)
}
\arguments{
\item{eDBN}{object of class graphNEL (or its adjacency matrix), representing estimated structure (not necessarily acyclic) to be compared to the ground truth graph}

\item{trueDBN}{object of class graphNEL (or its adjacency matrix), representing the ground truth structure (not necessarily acyclic)}

\item{struct}{option used to determine if the initial or the transition structure should be plotted; accaptable values are init or trans}

\item{b}{number of static variables in one time slice of a DBN; note that for function to work correctly all static variables have to be in the first b columns of the matrix}

\item{showcl}{logical, when TRUE (default) nodes are shown in clusters according to the time slice the belong to}

\item{...}{optional parameters passed to \code{Rgraphviz} plotting functions e.g. \code{main}, \code{fontsize}}
}
\value{
plots the graph highlights differences between 'eDBN' (estimated DBN) and 'trueDBN' (ground truth); edges which are different in 'eDBN' compared to 'trueDBN' are coloured according to the type of a difference: false-positive, false-negative and error in direction.
}
\description{
This function plots an estimated DBN such that the edges which are different to the ground truth DBN are highlighted.
}
\examples{
dbnscore<-scoreparameters("bge",DBNdata,
dbnpar = list(samestruct=TRUE, slices=5, b=3),
DBN=TRUE)
\dontrun{
orderDBNfit<-iterativeMCMC(dbnscore,chainout = TRUE, mergetype = "skeleton",scoreout=TRUE,alpha=0.4)
plotdiffsDBN(getDAG(orderDBNfit),DBNmat,struct="trans",b=3)
plotdiffsDBN(getDAG(orderDBNfit),DBNmat,struct="init",b=3)
}
}
\author{
Polina Suter
}
