% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBNfns.R
\name{compact2full}
\alias{compact2full}
\title{Deriving an adjecency matrix of a full DBN}
\usage{
compact2full(DBNmat, slices, b = 0)
}
\arguments{
\item{DBNmat}{a square matrix, representing initial and transitional structure of a DBN; the size of matrix is 2*dyn+b}

\item{slices}{integer, number of slices in an unrolled DBN}

\item{b}{integer, number of static variables}
}
\value{
an adjacency matrix of an unrolled DBN
}
\description{
This function transforms a compact 2-slice adjacency matrix of DBN into full T-slice adjacency matrix
}
\examples{
compact2full(DBNmat, slices=5, b=3)
}
