% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performanceassess.R, R/plotS3.R,
%   R/printmethods.R, R/summary.R
\name{itercomp}
\alias{itercomp}
\alias{plot.itercomp}
\alias{print.itercomp}
\alias{summary.itercomp}
\title{Performance assessment of iterative MCMC scheme against a known Bayesian network}
\usage{
itercomp(MCMCmult, truedag, cpdag = TRUE, p = 0.5, trans = TRUE)

\method{plot}{itercomp}(x, ..., vars = c("FP", "TP"), type = "b", col = "blue", showit = FALSE)

\method{print}{itercomp}(x, ...)

\method{summary}{itercomp}(object, ...)
}
\arguments{
\item{MCMCmult}{an object which of class \code{iterativeMCMC}, see also \code{\link{iterativeMCMC}})}

\item{truedag}{ground truth DAG which generated the data used in the search procedure; represented by an object of class \code{\link[graph]{graphNEL}} or an adjacency matrix}

\item{cpdag}{logical, if TRUE (FALSE by default) all DAGs are first converted to their respective equivalence classes (CPDAG)}

\item{p}{threshold such that only edges with a higher posterior probability will be retained in the directed graph summarising the sample of DAGs at each iteration from \code{MCMCmult} if parameter \code{sample} set to TRUE}

\item{trans}{logical, for DBNs indicates if model comparions are performed for transition structure; when \code{trans} equals FALSE the comparison is performed for initial structures of estimated models and the ground truth DBN; for usual BNs the parameter is disregarded}

\item{x}{object of class 'itercomp'}

\item{...}{ignored}

\item{vars}{a tuple of variables which will be used for 'x' and 'y' axes; possible values: "SHD", "TP", "FP", "TPR", "FPR", "FPRn", "FDR", "score"}

\item{type}{type of line in the plot;"b" by default}

\item{col}{colour of line in the plot; "blue" by default}

\item{showit}{logical, defines if points are labelled with the corresponding number of search space expansion}

\item{object}{object of class 'itercomp'}
}
\value{
an object if class \code{itersim}, a matrix with the number of rows equal to the number of expansion iterations in \code{iterativeMCMC}, and 8 columns reporting for 
the maximally scoring DAG uncovered at each iteration (or for a summary over the sample of DAGs if \code{sample} parameter set to TRUE) 
the number of true positive edges ('TP'), the number of false positive edges ('FP'), 
the true positive rate ('TPR'), the structural Hamming distance ('SHD'), false positive rate ('FPR'),
false discovery rate ('FDR') and the score of the DAG (`score').
}
\description{
This function compute 8 different metrics of structure fit of an object of class \code{iterativeMCMC} to the ground truth DAG (or CPDAG). Object of class
\code{iterativeMCMC} stores MAP (consensus) graph at from each search space expansion step. This function computes structure fit of
each of the stored graphs to the ground truth one. Computed metrics include: TP, FP, TPR, FPR, FPRn, FDR, SHD. See metrics description in
see also \code{\link{compareDAGs}}.
}
\examples{
gsim.score<-scoreparameters("bge", gsim)
\dontrun{
MAPestimate<-iterativeMCMC(gsim.score)
itercomp(MAPestimate, gsimmat)
}
}
\author{
Polina Suter
}
