% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{prob_association}
\alias{prob_association}
\title{Calculate probability of an association between presence/absence of local genotype configuration and case-control label}
\usage{
prob_association(y, G, ploidy = rep(2L, length(y)),
  prior_prob_association = 0.01, prior_prob_dominant = 0.5,
  tau0_shape = c(1, 1), by_MOI = FALSE, ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one row per individual and one column per variant.}

\item{ploidy}{Integer vector giving ploidy of samples.}

\item{prior_prob_association}{The prior probability of association.}

\item{prior_prob_dominant}{The prior probability of dominant inheritance given that there is an association.}

\item{tau0_shape}{Beta shape hyper-priors for prior on rate of case labels.}

\item{by_MOI}{Logical value determining whether to return probabilities broken down by mode of inheritance.}

\item{...}{Other arguments to pass to \code{\link{log_BF}}.}
}
\value{
Probability of association.
}
\description{
Calculate probability of an association between presence/absence of local genotype configuration and case-control label
}

