% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interventionest.R
\name{DAGintervention}
\alias{DAGintervention}
\title{Exact estimation of intervention effects for a single DAG or a chain of sampled DAGs}
\usage{
DAGintervention(incidences, dataParams, sample = TRUE, unrollDBN = TRUE)
}
\arguments{
\item{incidences}{a single adjacency matrix of a list of adjacency matrices of
sampled DAGs, with entry [i,j] equal to 1 when a directed edge exists from
node i to node j}

\item{dataParams}{the data and parameters used to learn the DAGs derived from the
\code{\link[BiDAG]{scoreparameters}} function of the BiDAG package}

\item{sample}{logical indicating whether to sample the parameters of each node
from the posterior (TRUE, default) or to take the expectation (FALSE)}

\item{unrollDBN}{logical indicating whether to unroll a DBN to a full DAG over
all time slices (TRUE, default) or to use the compact representation (FALSE)}
}
\value{
a single matrix or a list of matrices containing the full set of
intervention effects for each input DAG. Entry [i,j] is the downstream
effect on node j of intervening on node i
(the difference observed at node j when setting node i to 1 and 0)
}
\description{
\code{DAGintervention} takes a DAG or a sampled chain of DAGs (for example from
the \code{\link[BiDAG]{partitionMCMC}} function of the BiDAG package) and computes the
intervention effect of each node on all others. For binary data, this is performed
by exhaustively examining all possible binary states. This is exponentially complex in the
number of variables which should therefore be limited to around 20 or fewer. For more
variables there is a Monte Carlo version \code{\link{DAGinterventionMC}} instead.
For continuous data, the intervention estimation is performed by extracting the edge coefficients from 
their posterior distribution and using matrix inversion following arXiv:2010.00684.
}
\examples{

scoreParam <- BiDAG::scoreparameters("bde", BiDAG::Asia)
causalmat <- DAGintervention(BiDAG::Asiamat, scoreParam)

}
\seealso{
\code{\link[BiDAG]{scoreparameters}}
}
