/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.BlockUpperTriangularMatrixParameter;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VectorSliceParameter;
import java.util.ArrayList;
import java.util.List;

public class TransposedBlockUpperTriangularMatrixParameter
extends BlockUpperTriangularMatrixParameter {
    int colDim;
    private List<Parameter> slices = null;

    public TransposedBlockUpperTriangularMatrixParameter(String string, Parameter[] parameterArray) {
        super(string, parameterArray, false);
        int n;
        this.colDim = n = parameterArray[parameterArray.length - 1].getSize();
    }

    public static TransposedBlockUpperTriangularMatrixParameter recast(String string, CompoundParameter compoundParameter) {
        int n = compoundParameter.getParameterCount();
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = compoundParameter.getParameter(i);
        }
        return new TransposedBlockUpperTriangularMatrixParameter(string, parameterArray);
    }

    @Override
    protected int getRow(int n) {
        return n % this.getRowDimension();
    }

    @Override
    protected int getColumn(int n) {
        return n / this.getRowDimension();
    }

    @Override
    boolean matrixCondition(int n, int n2) {
        return n >= n2;
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        if (this.matrixCondition(n, n2)) {
            this.getParameter(n2).setParameterValueQuietly(n - n2, d);
            this.fireParameterChangedEvent(n2 * this.getRowDimension() + n, Variable.ChangeType.VALUE_CHANGED);
        }
    }

    @Override
    public Parameter getParameter(int n) {
        if (this.slices == null) {
            this.slices = new ArrayList<Parameter>();
            for (int i = 0; i < this.getColumnDimension(); ++i) {
                VectorSliceParameter vectorSliceParameter = new VectorSliceParameter(this.getParameterName() + "." + i, i);
                for (int j = i; j < this.getRowDimension(); ++j) {
                    vectorSliceParameter.addParameter(super.getParameter(j));
                }
                this.slices.add(vectorSliceParameter);
            }
        }
        return this.slices.get(n);
    }

    @Override
    protected int getInnerDimension(int n, int n2) {
        return n - n2;
    }

    @Override
    public int getRowDimension() {
        return this.getParameterCount();
    }

    @Override
    public int getColumnDimension() {
        return this.colDim;
    }
}

