/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.glm;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import dr.inference.distribution.DensityModel;
import dr.inference.distribution.ParametricMultivariateDistributionModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Transform;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ExperimentalGeneralizedLinearModel
extends AbstractModelLikelihood {
    private final Transform linkFunction;
    private final DensityModel density;
    private final boolean isMultivariateDensity;
    private final Parameter dependentParameter;
    private final List<Parameter> independentParameter = new ArrayList<Parameter>();
    private final List<Parameter> independentParameterDelta = new ArrayList<Parameter>();
    private final List<DesignMatrix> designMatrix = new ArrayList<DesignMatrix>();
    private int numIndependentVariables = 0;
    private int numRandomEffects = 0;
    private int N;
    protected List<Parameter> randomEffects = null;
    private double[] transformedXBeta;
    private double[] storedTransformedXBeta;
    private boolean transformedXBetaKnown = false;
    private double[] Y;
    private double storedLogLikelihood;
    private double logLikelihood;
    private boolean likelihoodKnown = false;

    public ExperimentalGeneralizedLinearModel(Parameter parameter, DensityModel densityModel, LinkFunction linkFunction) {
        super("glmModelNew");
        this.dependentParameter = parameter;
        this.linkFunction = linkFunction.getTransform();
        this.density = densityModel;
        this.isMultivariateDensity = densityModel instanceof ParametricMultivariateDistributionModel;
        this.addModel(densityModel);
        if (parameter != null) {
            this.addVariable(parameter);
            this.N = parameter.getDimension();
        } else {
            this.N = 0;
        }
        this.transformedXBeta = new double[this.N];
        this.storedTransformedXBeta = new double[this.N];
        this.Y = parameter.getParameterValues();
        this.transformedXBetaKnown = false;
        this.likelihoodKnown = false;
    }

    public void addRandomEffectsParameter(Parameter parameter) {
        if (this.randomEffects == null) {
            this.randomEffects = new ArrayList<Parameter>();
        }
        if (this.N != 0 && parameter.getDimension() != this.N) {
            throw new RuntimeException("Random effects have the wrong dimension");
        }
        this.addVariable(parameter);
        this.randomEffects.add(parameter);
        ++this.numRandomEffects;
    }

    public void addIndependentParameter(Parameter parameter, DesignMatrix designMatrix, Parameter parameter2) {
        if (this.N == 0) {
            this.N = designMatrix.getRowDimension();
        }
        this.designMatrix.add(designMatrix);
        this.independentParameter.add(parameter);
        this.independentParameterDelta.add(parameter2);
        if (this.designMatrix.size() != this.independentParameter.size()) {
            throw new RuntimeException("Independent variables and their design matrices are out of sync");
        }
        this.addVariable(parameter);
        this.addVariable(designMatrix);
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
        ++this.numIndependentVariables;
        Logger.getLogger("dr.inference").info("\tAdding independent predictors '" + parameter.getStatisticName() + "' with design matrix '" + designMatrix.getStatisticName() + "'");
    }

    public boolean getAllIndependentVariablesIdentifiable() {
        SingularValueDecomposition singularValueDecomposition;
        int n;
        int n2;
        int n3 = 0;
        for (DesignMatrix designMatrix : this.designMatrix) {
            n3 += designMatrix.getColumnDimension();
        }
        Object object = new double[this.N][n3];
        int n4 = 0;
        for (DesignMatrix designMatrix : this.designMatrix) {
            n2 = designMatrix.getColumnDimension();
            for (n = 0; n < this.N; n += 1) {
                for (int i = 0; i < n2; ++i) {
                    object[n][n4 + i] = designMatrix.getParameterValue(n, i);
                }
            }
            n4 += n2;
        }
        Object object2 = object;
        if (((Object)object).length < ((Object)object[0]).length) {
            object2 = new double[((Object)object[0]).length][((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                for (n2 = 0; n2 < ((Object)object[i]).length; ++n2) {
                    object2[n2][i] = object[i][n2];
                }
            }
        }
        n = n3 == (n2 = (singularValueDecomposition = new SingularValueDecomposition(new DenseDoubleMatrix2D((double[][])object2))).rank()) ? 1 : 0;
        Logger.getLogger("dr.inference").info("\tTotal # of predictors = " + n3 + " and rank = " + n2);
        return n != 0;
    }

    public double[] getXBeta() {
        Parameter parameter;
        int n;
        double[] dArray = new double[this.N];
        for (n = 0; n < this.numIndependentVariables; ++n) {
            parameter = this.independentParameter.get(n);
            Parameter parameter2 = this.independentParameterDelta.get(n);
            DesignMatrix designMatrix = this.designMatrix.get(n);
            int n2 = parameter.getDimension();
            for (int i = 0; i < n2; ++i) {
                double d = parameter.getParameterValue(i);
                if (parameter2 != null) {
                    d *= parameter2.getParameterValue(i);
                }
                for (int j = 0; j < this.N; ++j) {
                    int n3 = j;
                    dArray[n3] = dArray[n3] + designMatrix.getParameterValue(j, i) * d;
                }
            }
        }
        for (n = 0; n < this.numRandomEffects; ++n) {
            parameter = this.randomEffects.get(n);
            for (int i = 0; i < this.N; ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + parameter.getParameterValue(i);
            }
        }
        return dArray;
    }

    public double[] getXBeta(int n) {
        double[] dArray = new double[this.N];
        Parameter parameter = this.independentParameter.get(n);
        Parameter parameter2 = this.independentParameterDelta.get(n);
        DesignMatrix designMatrix = this.designMatrix.get(n);
        int n2 = parameter.getDimension();
        for (int i = 0; i < n2; ++i) {
            double d = parameter.getParameterValue(i);
            if (parameter2 != null) {
                d *= parameter2.getParameterValue(i);
            }
            for (int j = 0; j < this.N; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + designMatrix.getParameterValue(j, i) * d;
            }
        }
        if (this.numRandomEffects != 0) {
            throw new RuntimeException("Attempting to retrieve fixed effects without controlling for random effects");
        }
        return dArray;
    }

    public int getNumberOfFixedEffects() {
        return this.numIndependentVariables;
    }

    public int getNumberOfRandomEffects() {
        return this.numRandomEffects;
    }

    public Parameter getFixedEffect(int n) {
        return this.independentParameter.get(n);
    }

    public Parameter getRandomEffect(int n) {
        return this.randomEffects.get(n);
    }

    public Parameter getDependentVariable() {
        return this.dependentParameter;
    }

    public int getEffectNumber(Parameter parameter) {
        return this.independentParameter.indexOf(parameter);
    }

    public List<Parameter> getIndependentParameter() {
        return this.independentParameter;
    }

    public List<Parameter> getIndependentParameterDelta() {
        return this.independentParameterDelta;
    }

    public List<DesignMatrix> getDesignMatrix() {
        return this.designMatrix;
    }

    public double[][] getX(int n) {
        return this.designMatrix.get(n).getParameterAsMatrix();
    }

    private void calculateTransformedXBeta() {
        double[] dArray = this.getXBeta();
        for (int i = 0; i < this.N; ++i) {
            this.transformedXBeta[i] = this.linkFunction.inverse(dArray[i]);
        }
        this.transformedXBetaKnown = true;
    }

    private double calculateLogLikelihood() {
        if (!this.transformedXBetaKnown) {
            this.calculateTransformedXBeta();
        }
        double d = 0.0;
        if (!this.isMultivariateDensity) {
            for (int i = 0; i < this.Y.length; ++i) {
                this.density.getLocationVariable().setValue(0, this.transformedXBeta[i]);
                d += this.density.logPdf(new double[]{this.Y[i]});
            }
        }
        return d;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
        }
        return this.logLikelihood;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.dependentParameter) {
            this.Y = this.dependentParameter.getParameterValues();
        }
        this.transformedXBetaKnown = false;
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        System.arraycopy(this.transformedXBeta, 0, this.storedTransformedXBeta, 0, this.transformedXBeta.length);
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        System.arraycopy(this.storedTransformedXBeta, 0, this.transformedXBeta, 0, this.transformedXBeta.length);
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getLogLikelihood();
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new LogColumn[this.N];
        for (int i = 0; i < this.N; ++i) {
            logColumnArray[i] = new NumberArrayColumn(this.getId() + i, i);
        }
        return logColumnArray;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }

    public static enum LinkFunction {
        IDENTITY(new Transform.NoTransform()),
        LOG(new Transform.LogTransform()),
        LOGIT(new Transform.LogitTransform());

        private final Transform transform;

        private LinkFunction(Transform transform) {
            this.transform = transform;
        }

        public Transform getTransform() {
            return this.transform;
        }
    }

    private class NumberArrayColumn
    extends NumberColumn {
        private final int index;

        public NumberArrayColumn(String string, int n) {
            super(string);
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            return ExperimentalGeneralizedLinearModel.this.getXBeta()[this.index];
        }
    }
}

