/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent.structure;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.colouring.ColourChangeMatrix;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.util.Date;
import dr.evolution.util.TaxonList;
import dr.evolution.util.TimeScale;

public class StructuredCoalescentSimulator {
    public static final String COALESCENT_TREE = "structuredCoalescentTree";
    public static final String COALESCENT_SIMULATOR = "structuredCoalescentSimulator";
    public static final String ROOT_HEIGHT = "rootHeight";

    public Tree simulateTree(TaxonList[] taxonListArray, DemographicFunction[] demographicFunctionArray, ColourChangeMatrix colourChangeMatrix) {
        int n;
        int n2;
        SimpleNode[][] simpleNodeArray = new SimpleNode[taxonListArray.length][];
        for (int i = 0; i < taxonListArray.length; ++i) {
            simpleNodeArray[i] = new SimpleNode[taxonListArray[i].getTaxonCount()];
            for (n2 = 0; n2 < taxonListArray[i].getTaxonCount(); ++n2) {
                simpleNodeArray[i][n2] = new SimpleNode();
                simpleNodeArray[i][n2].setTaxon(taxonListArray[i].getTaxon(n2));
            }
        }
        TimeScale timeScale = null;
        n2 = 0;
        for (int i = 0; i < taxonListArray.length; ++i) {
            for (n = 0; n < taxonListArray[i].getTaxonCount(); ++n) {
                if (TaxonList.Utils.hasAttribute(taxonListArray[i], n, "date")) {
                    n2 = 1;
                    Date date = (Date)taxonListArray[i].getTaxonAttribute(n, "date");
                    if (date == null || timeScale != null && !date.after((Date)timeScale)) continue;
                    timeScale = date;
                    continue;
                }
                simpleNodeArray[i][n].setHeight(0.0);
            }
        }
        if (n2 != 0) {
            assert (timeScale != null);
            TimeScale timeScale2 = new TimeScale(timeScale.getUnits(), true, ((Date)timeScale).getAbsoluteTimeValue());
            for (n = 0; n < taxonListArray.length; ++n) {
                for (int i = 0; i < taxonListArray[n].getTaxonCount(); ++i) {
                    Date date = (Date)taxonListArray[n].getTaxonAttribute(i, "date");
                    if (date == null) {
                        throw new IllegalArgumentException("Taxon, " + taxonListArray[n].getTaxonId(i) + ", is missing its date");
                    }
                    simpleNodeArray[n][i].setHeight(timeScale2.convertTime(date.getTimeValue(), date));
                }
                if (demographicFunctionArray[0].getUnits() == timeScale.getUnits()) continue;
            }
        }
        return new SimpleTree(this.simulateCoalescent(simpleNodeArray, demographicFunctionArray, colourChangeMatrix));
    }

    public SimpleNode simulateCoalescent(SimpleNode[][] simpleNodeArray, DemographicFunction[] demographicFunctionArray, ColourChangeMatrix colourChangeMatrix) {
        SimpleNode[] simpleNodeArray2 = this.simulateCoalescent(simpleNodeArray, demographicFunctionArray, colourChangeMatrix, 0.0, Double.POSITIVE_INFINITY);
        for (int i = 0; simpleNodeArray2.length > 1 && i < 1000; ++i) {
            simpleNodeArray2 = this.simulateCoalescent(simpleNodeArray, demographicFunctionArray, colourChangeMatrix, 0.0, Double.POSITIVE_INFINITY);
        }
        if (simpleNodeArray2.length > 1) {
            throw new RuntimeException(simpleNodeArray2.length + " nodes found where there should have been 1, after 1000 tries!");
        }
        return simpleNodeArray2[0];
    }

    public SimpleNode[] simulateCoalescent(SimpleNode[][] simpleNodeArray, DemographicFunction[] demographicFunctionArray, ColourChangeMatrix colourChangeMatrix, double d, double d2) {
        return null;
    }
}

