/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.LinearGrowth;
import dr.evolution.util.Units;

public class PowerLawGrowth
extends LinearGrowth {
    private double r;

    public PowerLawGrowth(Units.Type type) {
        super(type);
    }

    public double getR() {
        return this.r;
    }

    public void setR(double d) {
        this.r = d;
    }

    @Override
    public double getDemographic(double d) {
        if (d > 0.0) {
            throw new RuntimeException("Negative times only!");
        }
        return this.getN0() * Math.pow(-d, this.r);
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("getIntensity is not implemented (and not finite); use getIntegral instead");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getInverseIntegral(double d, double d2) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getIntegral(double d, double d2) {
        return (Math.pow(-d2, -this.r + 1.0) - Math.pow(-d, -this.r + 1.0)) / (this.getN0() * (this.r - 1.0));
    }

    @Override
    public int getNumArguments() {
        return 2;
    }

    @Override
    public String getArgumentName(int n) {
        if (n == 0) {
            return "N0";
        }
        return "r";
    }

    @Override
    public double getArgument(int n) {
        if (n == 0) {
            return this.getN0();
        }
        return this.getR();
    }

    @Override
    public void setArgument(int n, double d) {
        if (n == 0) {
            this.setN0(d);
        } else {
            this.setR(d);
        }
    }

    @Override
    public double getLowerBound(int n) {
        if (n == 0) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        PowerLawGrowth powerLawGrowth = new PowerLawGrowth(this.getUnits());
        powerLawGrowth.setN0(this.getN0());
        powerLawGrowth.r = this.r;
        return powerLawGrowth;
    }
}

