% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coreInfluence.BchronologyRun.R
\name{coreInfluence}
\alias{coreInfluence}
\title{Find the influence of dates in a pair of Bchronology runs across the core}
\usage{
coreInfluence(
  bchrRun1,
  bchrRun2,
  percentile = 0.95,
  type = c("plot", "summary", "max"),
  ageTolerance = 500,
  ...
)
}
\arguments{
\item{bchrRun1}{The output of a run of the \code{\link{Bchronology}} function}

\item{bchrRun2}{The output of another run of the \code{\link{Bchronology}} function, possibly with different dates.
Note this must have the same value of \code{predictPositions} as \code{bchrRun1}}

\item{percentile}{The value of the percentile to compare the uncertainties. Default is 95\%}

\item{type}{if \code{plot} will return a plot of the difference in uncertainties at the specified percentile level.
If \code{summary} will return text output of the reduction in uncertainty at each position. If \code{max} will return the
position of the maximum decrease in uncertainty and a list of all the positions where the reduction in uncertainty exceeds the value of
\code{ageTolerance}}

\item{ageTolerance}{A value in years for which to report the positions at which the reduction in uncertainty exceeds this value.}

\item{...}{Additional arguments to plot}
}
\value{
Depending on type will outputs some text and plots providing the influence values for the cores in question.
}
\description{
This function takes as input two \code{\link{Bchronology}} runs and compares the uncertainty intervals. It does this by
computing the mean uncertainty across the core (\code{type = 'mean'}) at a specified percentile level (e.g. 95\%) and
subsequently reporting the reduction/increase in uncertainty between the two runs. Both cores must
have the same set of depths/positions at regular intervals.
}
\details{
For example, if the \code{ageTolerance} value is 500 years, then \code{coreInfluence} will return all of the positions at
which the uncertainty reduction is bigger than 500.
}
\examples{
\donttest{
data(Glendalough)
# Start with a run that remove two dates
GlenOut1 <- Bchronology(
  ages = Glendalough$ages[-c(3:4)],
  ageSds = Glendalough$ageSds[-c(3:4)],
  calCurves = Glendalough$calCurves[-c(3:4)],
  positions = Glendalough$position[-c(3:4)],
  positionThicknesses = Glendalough$thickness[-c(3:4)],
  ids = Glendalough$id[-c(3:4)],
  predictPositions = seq(0, 1500, by = 10)
)
GlenOut2 <- Bchronology(
  ages = Glendalough$ages,
  ageSds = Glendalough$ageSds,
  calCurves = Glendalough$calCurves,
  positions = Glendalough$position,
  positionThicknesses = Glendalough$thickness,
  ids = Glendalough$id,
  predictPositions = seq(0, 1500, by = 10)
)

# Now compare their influence
coreInfluence(GlenOut1,
  GlenOut2,
  type = c("max", "plot"),
  xlab = "Age (cal years BP)",
  ylab = "Depth (cm)",
  main = "Chronology difference at 95\% for
              Glendalough removing two dates",
  las = 1
)
}
}
\seealso{
\code{\link{Bchronology}},  \code{\link{choosePositions}}, \code{\link{dateInfluence}} for finding the influence of removing a single date from a core
}
