% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transferdatatolist_Stopboundinf.R
\name{Stopboundinf}
\alias{Stopboundinf}
\title{Stopboundinf}
\usage{
Stopboundinf(
  Stop.type = "Early-Pocock",
  Boundary.type = "Symmetric",
  cutoff = c(0.9928, 0.0072)
)
}
\arguments{
\item{Stop.type}{The type of stopping boundary should be "Early-Pocock", "Early-OBF" and "Noearly". Default is "Early-Pocock" which is the Pocock boundary with early stopping.}

\item{Boundary.type}{Whether the futility boundary and the efficacy boundary are the same conservative.
Default is "Symmetric" which means they are as conservative as each other.
Boundary.type = "Asymmetric" means that the efficacy boundary and the futility boundary are not as conservative as each other}

\item{cutoff}{= c(cutoff1, cutoff2). A numerical vector of cutoff value for each boundary.
The first element is the efficacy boundary cutoff. The second element is the futility boundary cutoff
Pr(theta_1 > theta_0|D_n) > cutoff1. Should input the cutoff1 for efficacy boundary as the first element
Pr(theta_1 < theta_0|D_n) < cutoff2. Should input the cutoff2 for futility boundary as the first element}
}
\value{
The list of information required for boundary construction function 'Stopbound.inf'
}
\description{
This function summaries and checks stopping boundary information.
}
\examples{
Stop.type = "Early-Pocock" #(Pocock boundarty is a flat boundary across time)
Boundary.type = "Symmetric"
cutoff = c(0.9928, 0.0072)

Stopbound.inf = Stopboundinf(Stop.type, Boundary.type, cutoff)
#Stopbound.inf
#$Stop.type
# [1] "Early-Pocock"
#$Boundary.type
#[1] "Symmetric"
#$cutoff
# [1] 0.9928 0.0072
}
\author{
Ziyan Wang
}
