% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{fit_srsc_ROC}
\alias{fit_srsc_ROC}
\title{fit a model to data in the case of
A Single reader and A Single modality (srsc).}
\usage{
fit_srsc_ROC(
  dataList,
  prior = -1,
  new.imaging.device = TRUE,
  dataList.Name = "",
  ModifiedPoisson = FALSE,
  model_reparametrized = FALSE,
  verbose = FALSE,
  type_to_be_passed_into_plot = "l",
  multinomial = FALSE,
  DrawCurve = TRUE,
  PreciseLogLikelihood = TRUE,
  Drawcol = TRUE,
  mesh.for.drawing.curve = 10000,
  summary = TRUE,
  DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE,
  cha = 4,
  ite = 3000,
  dig = 5,
  war = floor(ite/5),
  see = 1234,
  prototype = FALSE,
  ww = -0.81,
  www = 0.001,
  mm = 0.65,
  mmm = 0.001,
  vv = 5.31,
  vvv = 0.001,
  zz = 1.55,
  zzz = 0.001,
  ...
)
}
\arguments{
\item{dataList}{A list, to be fitted a model.
For example, in case of a single reader and a single modality,
it consists of  \code{f, h, NL, NI, C}.
The detail of these dataset,
see the example data-sets.
Note that the maximal number of confidence level,
denoted by  \code{C}, are included,
however,
should not include its each confidence level in \code{dataList}}

\item{prior}{positive integer, to select the prior}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{dataList.Name}{This is not for user, but the author for this package development.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}.

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per lesion}},
and a model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pairs of TPF per lesion and FPF  \strong{\emph{per lesion}}.

Similarly,

If \code{ModifiedPoisson = TRUE},
then Poisson rate of false alarm is calculated \strong{\emph{per image}},
and a model is fitted
so that the FROC curve is an expected curve
 of points consisting of the pair of TPF per lesion and FPF  \strong{\emph{per image}}.



For more details, see the author's paper in which I explained \emph{per image} and \emph{per lesion}.
(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  }, now, it is omiited from this package, because the size of vignettes are large.)

If \code{ModifiedPoisson = TRUE},
 then the \emph{False Positive Fraction (FPF)} is defined as follows
 (\eqn{F_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_L}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_L}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_L}, }

  \deqn{ \frac{F_4+F_5}{N_L}, }

   \deqn{ \frac{F_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).
To emphasize its denominator  \eqn{N_L},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per lesion}.


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\emph{False Positive Fraction (FPF)} is given by

\deqn{ \frac{F_1+F_2+F_3+F_4+F_5}{N_I}, }

\deqn{ \frac{F_2+F_3+F_4+F_5}{N_I}, }

 \deqn{ \frac{F_3+F_4+F_5}{N_I}, }

  \deqn{ \frac{F_4+F_5}{N_I}, }

   \deqn{ \frac{F_5}{N_I}, }

where \eqn{N_I} is the number of images (trial).
To emphasize its denominator \eqn{N_I},
we also call it the \emph{False Positive Fraction (FPF)} \strong{per image}.


The model is fitted so that
the estimated FROC curve can be ragraded
 as the expected pairs of   FPF per image and TPF per lesion (\code{ModifiedPoisson = FALSE })

 or as the expected pairs of   FPF per image and TPF per lesion  (\code{ModifiedPoisson = TRUE})

If \code{ModifiedPoisson = TRUE}, then FROC curve means the expected pair of FPF \strong{per lesion} and TPF.

On the other hand, if  \code{ModifiedPoisson = FALSE}, then FROC curve means the expected pair of \strong{FPF per image} and TPF.




So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it uses only per images (trial). Since we can divide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author also developed FROC theory to consider FROC analysis under per signal.
One can see that the FROC curve is rigid with respect to change of a number of images, so, it does not matter whether \code{ModifiedPoisson = TRUE} or \code{FALSE}.
This rigidity of curves means that the number of images is redundant parameter for the FROC trial and
thus the author try to exclude it.


Revised 2019 Dec 8
Revised 2019 Nov 25
Revised 2019 August 28}

\item{model_reparametrized}{A logical, if TRUE, then a model under construction is used.}

\item{verbose}{A logical, if \code{TRUE}, then the redundant summary is printed in \R console.
If \code{FALSE}, it suppresses output from this function.}

\item{type_to_be_passed_into_plot}{"l" or "p".}

\item{multinomial}{A logical, if \code{TRUE} then model is the most classical one using multinomial distribution.}

\item{DrawCurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the curve is to be drawn. TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}.
The reason why the author make this variable \code{DrawCurve} is that it takes long time in MRMC case to draw curves, and thus Default value is \code{FALSE} in the case of MRMC data.}

\item{PreciseLogLikelihood}{Logical, that is \code{TRUE} or \code{FALSE}. If \code{PreciseLogLikelihood  = TRUE}(default), then Stan calculates the precise log likelihood with target formulation.
If \code{PreciseLogLikelihood  = FALSE}, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.
In past, I distinct the stan file, one is target formulation and the another is not. But non-target formulation cause some Jacobian warning,
thus I made all stanfile with target formulation when I uploaded to CRAN.
 Thus this variable is now meaningless.}

\item{Drawcol}{Logical: \code{TRUE} of \code{FALSE}. Whether the (A)FROC curve is to be drawn  by using color of dark theme. The Default value is a \code{TRUE}.}

\item{mesh.for.drawing.curve}{A positive large integer, indicating number of dots drawing the curves, Default =10000.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFP and CTP points are to be drawn. CFP: Cumulative false positive per lesion (or image) which is also called False Positive Fraction (FPF). CTP Cumulative True Positive per lesion  which is also called True Positive Fraction (TPF)..}

\item{cha}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{chains}.  A positive integer representing   the number of chains generated by Hamiltonian Monte Carlo method,
and, Default = 1.}

\item{ite}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{iter}. A positive integer representing  the  number of samples synthesized by Hamiltonian Monte Carlo method,
and, Default = 1111}

\item{dig}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}

\item{war}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{warmup}.  A positive integer representing the Burn in period, which must be less than \code{ite}. Defaults to
war = floor(ite/5)=10000/5=2000,}

\item{see}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{seed}.  A positive integer representing  seed used in stan,
Default = 1234.}

\item{prototype}{A logical, if \code{TRUE} then the model is no longer
a generative model. Namely, in generally speaking,
 a dataset drawn from the model
 cannot satisfy the condition that
 the sum of the numbers of hits over all confidence levels
  is bounded from the above by the number of lesions, namely,

\deqn{ \Sigma_c H_c \le N_L }

However, this model (\code{TRUE} )
 is good in the sense that it admits various initial values of MCMC sampling.

 if \code{FALSE}, then the model is precisely
  statistical model in the sense that
   any dataset drawn from the model
   satisfies that the sum of the number of hits is
 not greater than the number of lesions, namely,

  \deqn{ \Sigma_c H_c \le N_L. }
  This model is theoretically perfect.
   However, in the practically,
    the calculation will generates
     some undesired results
      which caused by the so-called floo .... I forget English :'-D.
 The flood point??? I forgeeeeeeeeeeeeet!!
  Ha. So, prior synthesizes very small hit rates such as 0.0000000000000001234 and it cause the non accurate calculation such as 0.00000,,,00000123/0.000.....000012345= 0.0012 which becomes hit rate and thus OH No!.
 Then it synthesizes Bernoulli success rate which is not less than 1 !!
 To avoid this, the author should develop the theory of prior to avoid this very small numbers, however the author has idea but now it does not success.




If \code{prototype = TRUE},
then the model for hits is the following:

\deqn{H_5 \sim Binomial(p_5,N_L)}
\deqn{H_4 \sim Binomial(p_4,N_L)}
\deqn{H_3 \sim Binomial(p_3,N_L)}
\deqn{H_2 \sim Binomial(p_2,N_L)}
\deqn{H_1 \sim Binomial(p_1,N_L)}


On the other hand,
if \code{prototype = FALSE},
then the model for hits is the following:

\deqn{H_5 \sim Binomial(               p_5,N_L      )                        }
\deqn{H_4 \sim Binomial( \frac{p_4}{1-p_5},N_L - H_5)                        }
\deqn{H_3 \sim Binomial( \frac{p_3}{1-p_5-p_4},N_L - H_5-H_4)                }
\deqn{H_2 \sim Binomial( \frac{p_2}{1-p_5-p_4-p_3},N_L - H_5-H_4-H_3)        }
\deqn{H_1 \sim Binomial( \frac{p_1}{1-p_5-p_4-p_3-p_2},N_L - H_5-H_4-H_3-H_2)}


Each number of lesions is adjusted
so that the sum of hits \eqn{\Sigma_c H_c} is less than
the number of lesions (signals, targets) \eqn{N_L}.
And hence the model in case of \code{prototype = FALSE}
is a generative model in the sense that
it can replicate datasets of FROC  arises.
Note that the adjustment of the number of lesions
in the above manner leads us the adjustment of hit rates.
The reason why we use the hit rates such as
\eqn{\frac{p_2}{1-p_5-p_4-p_3}} instead of \eqn{p_c} is that
it ensures the equality \eqn{ E[H_c/N_L] = p_c}.
 This equality is very important.
To establish Bayesian FROC theory so that it is
 compatible to the classical FROC theory, we need the following two equations,

  \deqn{ E[H_c/N_L] = p_c,}
  \deqn{ E[F_c/N_X] = q_c,}

where  \eqn{E} denotes the expectation and \eqn{N_X} is the number of lesion or the number of images and
\eqn{q_c} is a false alarm rate, namely, \eqn{ F_c \sim Poisson( q_c N_X)}.

Using the above two equations, we can establish the alternative Bayesian FROC theory preserving classical notions and
formulas. For the details, please see the author's pre print:

Bayesian Models for ,,, for?? I forget my paper title .... :'-D.
What the hell!? I forget,... My health is so bad to forget , .... I forget.




The author did not notice that the prototype is not a generative model. And hence
the author revised the model so that the model is exactly generative model.

But the reason why the author remains the prototype model(\code{prototype = TRUE})
is that the convergence of MCMC sampling in case of MRMC is not good in the current model (\code{prototype = FALSE}) .
Because it uses fractions \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2}} and which is very dangerous to numerical perspective.
For example, if \eqn{p_1} is very small, then the numerator and denominator of \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2}}  is very small.
Both of them is like 0.000000000000000123.... and such small number causes the non accurate results.
So, sometimes, it occurs that \eqn{\frac{p_1}{1-p_5-p_4-p_3-p_2} >1} which never occur in the theoretical perspective but
unfortunately, in numerically occurs.

SO, now, the author try to avoid such phenomenon by using priors but it now does not success.



Here of course we interpret the terms
such as \eqn{N_L - H_5-H_4-H_3} as
the remained targets after
reader get hits. The author thinks it is another manner to do so like \eqn{N_L -H_1-H2-H_3}, but it does not be employed.
Since the author thinks that the reader will assign his suspicious lesion location from high confidence level and in this view point
the author thinks it should be considered that targets are found from the highest confidence suspicious location.}

\item{ww}{Each of which is a real number  specifying one of the parameter of prior}

\item{www}{Each of which is a real number  specifying one of the parameter of prior}

\item{mm}{Each of which is a real number  specifying one of the parameter of prior}

\item{mmm}{Each of which is a real number  specifying one of the parameter of prior}

\item{vv}{Each of which is a real number  specifying one of the parameter of prior}

\item{vvv}{Each of which is a real number  specifying one of the parameter of prior}

\item{zz}{Each of which is a real number  specifying one of the parameter of prior}

\item{zzz}{Each of which is a real number  specifying one of the parameter of prior}

\item{...}{Additional arguments}
}
\value{
An S4 object of class \code{stanfitExtended},
which is an inherited S4 class from \code{stanfit}.

To change the S4 class, use
}
\description{
Build a \emph{fitted model object}  in case of  \strong{single reader
and single modality} data \code{dataList}. FPF is \strong{per image}.
}
\details{
Revised 2019.Jun. 17
}
\examples{
\dontrun{
#First, prepare the example data from this package.



          dat  <- get(data("dataList.Chakra.1"))




#Second, fit a model to data named "dat"





           fit <-  fit_srsc(dat)







#      Close the graphic device to avoid errors in R CMD check.

         Close_all_graphic_devices()



}# dottest
}
