% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorResearch.R
\name{priorResearch}
\alias{priorResearch}
\title{Research for Prior}
\usage{
priorResearch(z, m = 6, sd = 1, e = 0.01)
}
\arguments{
\item{z}{a real number, indicating \eqn{\theta_c}.}

\item{m}{a real number, specifying the mean of signal Gaussian}

\item{sd}{a real number, specifying the standard deviation of signal Gaussian}

\item{e}{a positive real number, indicating \eqn{\epsilon}.}
}
\value{
A real, to investigate prior

 \deqn{ \mu   + \sigma \Phi^{-1}(1- \epsilon + \Phi( \frac{\theta_{c} - \mu }{\sigma} ) ) - \Phi^{-1}( \Phi( \theta) \exp(\epsilon ))   }

 where,
 \code{m =  } \eqn{\mu},
 \code{sd =  } \eqn{\sigma},
 \code{z =  } \eqn{\theta},
 \code{e =  } \eqn{\epsilon}.
}
\description{
The autor investigates prior
}
\examples{
#========================================================================================
#            From this plot, we can evaluate the minimum value of x such that
#            the value is negative.
#========================================================================================


      x <- runif(100,-1,3 )  # Syntheisze 100 smaples from Uniform(-1,3)
      y <- priorResearch(x)

     plot(x,y)




}
