% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/validation_MRMC_Create_dataList_MRMC_Hit_from_rate_etc.R
\name{Confirm_hit_rates_are_correctly_made_in_case_of_MRMC}
\alias{Confirm_hit_rates_are_correctly_made_in_case_of_MRMC}
\title{Check hit rate is defined correctly}
\usage{
Confirm_hit_rates_are_correctly_made_in_case_of_MRMC(
  StanS4class.or.An.array.of.ppp
)
}
\arguments{
\item{StanS4class.or.An.array.of.ppp}{A stanfitExtended object or an array of component of hit rate namely \code{ppp}}
}
\value{
A  array with logical components. Its dimension costructed by number of readers and modalities.
}
\description{
Each hit rate is defined by dividing the area under
the probability density function into \code{C+1} regions.
Thus, the sum of hit rates over all confidence level
must be less than 1 which is checked by this function..



This function checks the sum of
 all hit rate over all confidence levels are less than 1 in case of MRMC

This code confirm the following inequality:

\eqn{\Sigma_{cd}}\code{ppp[cd,md,qd]} < 1

for each
 \code{cd,md} (  \code{cd} =1,2,...,\code{C},  \code{md} =1,2,...,\code{M} ).

  The return value is an array consisting of logical \R objects
 indicating whether the above inequality is \code{TRUE} or \code{FALSE}.


2020 Jam
}
\examples{
#========================================================================================
#                               array: ppp
#========================================================================================

              p.truth.array <- hits_rate_creator()


              Confirm_hit_rates_are_correctly_made_in_case_of_MRMC(p.truth.array)

\dontrun{
#========================================================================================
#                              fitted model object
#========================================================================================

              f <- fit_Bayesian_FROC(dd,ite  = 1111)

              Confirm_hit_rates_are_correctly_made_in_case_of_MRMC(f)

}
}
