% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_EAP_by_array.R
\name{extract_estimates_MRMC}
\alias{extract_estimates_MRMC}
\title{MRMC: Extract All Posterior Mean Estimates from stanfitExtended object}
\usage{
extract_estimates_MRMC(StanS4class, dig = 3)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{dig}{A variable to be passed to the function \code{rstan::}\code{sampling}() of \pkg{rstan}  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}
}
\value{
EAPs, CIs which preserving its format, such as array, vector.
}
\description{
Extract Posterior Mean estimates, preserving its format, such as array, vector. From MRMC models, it extract the EAPs and CIs.
}
\details{
To validate our model has no bias,
that is comparison of true parameters of distributions and EAPs,
we have to extract the estimates from the stanfitExtended object.
And this function do it.
}
\examples{

\dontrun{

 fit <- fit_Bayesian_FROC(
              BayesianFROC::dataList.Chakra.Web.orderd,
              summary = FALSE,
              ite=111)

 EAPs <- extract_estimates_MRMC(fit)

}# dottest

}
\seealso{
extract_EAP_CI() is used  in the function \code{extract_estimates_MRMC()}.
}
