% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_latent_distribution.R
\name{draw_latent_noise_distribution}
\alias{draw_latent_noise_distribution}
\title{Visualization of the Latent Gaussian for false rates}
\usage{
draw_latent_noise_distribution(
  StanS4class,
  dark_theme = TRUE,
  dig = 3,
  mesh = 1000,
  new.imaging.device = TRUE,
  hit.rate = FALSE,
  false.alarm.rate = TRUE,
  both.hit.and.false.rate = FALSE,
  density = 22,
  color = TRUE,
  mathmatical.symbols = TRUE,
  type = 3
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{dark_theme}{TRUE or FALSE}

\item{dig}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \pkg{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{...??}.   A positive integer representing   the Significant digits, used in stan Cancellation.
Default = 5,}

\item{mesh}{Mesh for painting the area}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{hit.rate}{whether draws it. Default is \code{TRUE}.}

\item{false.alarm.rate}{whether draws it. Default is \code{TRUE}.}

\item{both.hit.and.false.rate}{whether draws it. Default is \code{TRUE}.}

\item{density}{A natural number, indicating the density of shading lines, in lines per inch.}

\item{color}{A color region is selected from black and white only. For more colors, put \code{FALSE}. For publication, the mono color is allowed in many case, so the author made this for such publication.}

\item{mathmatical.symbols}{A logical, whether legend is in plot.}

\item{type}{An integer, for the color of background and etc.}
}
\value{
Information of Latent Gaussians, such as mean and S.D. of the signal distributions and thresholds.
}
\description{
Plot the posterior mean
 of  model parameter \eqn{\theta} and
and the latent function, i.e.
 the differential logarithmic Gaussian \eqn{d \log \Phi(z)}.
}
\details{
Our FROC model use a latent
 Gaussian random variable to determine false rates which are defined as follows;

\deqn{ q_5(z_1,...z_C) = \int_{z5}^{\infty} d \log \Phi(z)dz}
\deqn{ q_4(z_1,...z_C) = \int_{z4}^{z5} d \log \Phi(z)dz}
\deqn{ q_3(z_1,...z_C) = \int_{z3}^{z4} d \log \Phi(z)dz}
\deqn{ q_2(z_1,...z_C) = \int_{z2}^{z3} d \log \Phi(z)dz}
\deqn{ q_1(z_1,...z_C) = \int_{z1}^{z2} d \log \Phi(z)dz}


 For example, in the following data, the number of false alarm data with confidence level 5 \strong{41} which
 is considered as an sample from the Poisson distribution of  its rate
\deqn{ q_5(z_1,...z_C) = \int_{z5}^{\infty} d \log \Phi(z)dz}


 So, this Gaussian distribution determines false rate, and this function \code{draw_latent_noise_distribution()} plot
 this Gaussian distribution  \eqn{d \log \Phi}  and
  the density  \eqn{ Gaussian(z|\mu,\sigma)} is also plotted to compare hit rates and false rates.
 thus, the author implement it in the \code{\link{draw_latent_signal_distribution}()},



\strong{\emph{ Example data:}}

 \emph{            A single reader and single modality case   }

------------------------------------------------------------------------------------------------------
\tabular{rccc}{
\code{NI=63,NL=124}   \tab \strong{ confidence level } \tab \strong{ No. of false alarms} \tab \strong{No. of hits}  \cr
 In R console ->      \tab \code{ c} \tab   \code{f }  \tab   \code{h}  \cr
  -----------------------\tab ----------------------- \tab ----------------------------- \tab ------------- \cr
\emph{definitely} present  \tab  5 \tab 1  \tab 41  \cr
 \emph{probably} present   \tab  4 \tab 2  \tab 22  \cr
 equivocal                 \tab  3 \tab 5  \tab 14  \cr
 subtle                    \tab  2 \tab 11 \tab 8   \cr
 \emph{very} subtle        \tab  1 \tab 13 \tab 1   \cr
 }

---------------------------------------------------------------------------------------------------


*  \emph{false alarms} = False Positives = FP

*  \emph{hits} = True Positives = TP
}
\examples{
\dontrun{
#========================================================================================
#   Shape of signal distribution strongly influences the value of AUC, so in the following
#   the author shows how it affects the estimates of AUCs.
#    We consider two data examples, one is a low AUC and the other is a high AUC.
#   In the high AUC case, the Signal Gaussain will be low variance and
#   in the low AUC case, the variance will desperse.  2019 August 4, 2019 Dec 17
#========================================================================================

#            ----- High AUC case --------

     viewdata(dataList.High)

     fit.High <- fit_Bayesian_FROC(dataList.High,ite=111)

     draw_latent_signal_distribution(fit.High)




#            ----- Low AUC case --------

     viewdata(dataList.Low)

     fit.Low <- fit_Bayesian_FROC(dataList.Low)

     draw_latent_signal_distribution(fit.Low)

}# dottest
}
\seealso{
\code{\link{draw_latent_signal_distribution}()}
}
