% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validation.dataset_srsc_for_different_NI_NL}
\alias{validation.dataset_srsc_for_different_NI_NL}
\title{Dataset creator from known distributions.}
\usage{
validation.dataset_srsc_for_different_NI_NL(NLvector = c(100, 10000,
  1e+06, 1e+08), ratio = 2, replicate.datset = 3,
  ModifiedPoisson = FALSE, mean.truth = 0.6, sd.truth = 5.3,
  z.truth = c(-0.8, 0.7, 2.38), ite = 111)
}
\arguments{
\item{NLvector}{Vector indicates the number of Lesions.}

\item{ratio}{Number of Images is determined by converting \code{ratio} * NLvector to a integer.}

\item{replicate.datset}{A Number indicate that how many you replicate dataset from user's specified dataset.}

\item{ModifiedPoisson}{Logical, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm is \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm is \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.(for details of models, see   \href{https://cran.r-project.org/package=BayesianFROC}{ vignettes  })

If \code{ModifiedPoisson = TRUE},
 then False Positive Fraction (FPF) is calculated as follows
 (\eqn{f_c} denotes the number of false alarms with confidence level \eqn{c} )


\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_L}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_L}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_L}, }

  \deqn{ \frac{f_4+f_5}{N_L}, }

   \deqn{ \frac{f_5}{N_L}, }

where \eqn{N_L} is a number of lesions (signal).


On the other hand,


if \code{ModifiedPoisson = FALSE} (Default), then
\deqn{ \frac{f_1+f_2+f_3+f_4+f_5}{N_I}, }

\deqn{ \frac{f_2+f_3+f_4+f_5}{N_I}, }

 \deqn{ \frac{f_3+f_4+f_5}{N_I}, }

  \deqn{ \frac{f_4+f_5}{N_I}, }

   \deqn{ \frac{f_5}{N_I}, }

where \eqn{N_I} is a number of images (trial).


So,data of FPF and TPF are changed thus, a fitted model is also changed whether  \code{ModifiedPoisson = TRUE} or \code{FALSE}.
In traditional FROC analysis, it use only per trial. But, if we devide one image into two images or more images, number of
trial is not important. And more important is per signal. So, the author developed FROC theory to consider FROC analysis under per signal.


Revised 2019 6.19}

\item{mean.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{sd.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{z.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{ite}{To be passed to the function \code{rstan::}\code{\link[rstan]{sampling}}() in \strong{rstan}. An argument of \code{rstan::}\code{\link[rstan]{sampling}}()  in which it is named \code{iter}. A positive integer representing  the  number of samples generated by Hamiltonian Monte Carlo method,
and, default = 10000. If your model could not converge, then raise this number. Must be greater for more reliable estimates.}
}
\description{
By specifying the parameters of binormal assumptions,
the dataset are created from this known distributions.
}
\examples{
\donttest{

   datasets <-validation.dataset_srsc_for_different_NI_NL(
               NLvector = c(100,10000000,1000000000),
               ite = 2222
               )


 # By the following, we can extract only datasets whose
 # model has converged.
   datasets$convergent.dataList.as.dataframe

}# dottest
}
