% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_HRFs.R
\name{HRF}
\alias{HRF}
\title{Canonical (double-gamma) HRF}
\usage{
HRF(t, deriv = 0, a1 = 6, b1 = 0.9, a2 = 12, b2 = 0.9, c = 0.35)
}
\arguments{
\item{t}{time vector}

\item{deriv}{\code{0} (default) for the HRF, \code{1} for the first derivative
of the HRF, or \code{2} for the second derivative of the HRF.}

\item{a1}{delay of response. Default: \code{6}}

\item{b1}{response dispersion. Default: \code{0.9}}

\item{a2}{delay of undershoot. Default: \code{12}}

\item{b2}{dispersion of undershoot. Default: \code{0.9}}

\item{c}{scale of undershoot. Default: \code{0.35}}
}
\value{
HRF vector (or dHRF, or d2HRF) corresponding to time
}
\description{
Calculate the HRF from a time vector and parameters. Optionally compute the
first or second derivative of the HRF instead.
}
\examples{
downsample <- 100
HRF(seq(0, 30, by=1/downsample))

}
