\name{PBvs}
\alias{PBvs}
\title{
Bayesian Variable Selection for linear regression models using parallel computing.
}
\description{
\code{PBvs} is a parallelized version of \code{\link[BayesVarSel]{Bvs}}.
}
\usage{
PBvs(formula, fixed.cov=c("Intercept"), data, prior.betas = "Robust",
     prior.models = "ScottBerger", n.keep = 10, n.nodes = 2, 
     priorprobs=NULL, time.test=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula }{Formula defining the most complex regression model in the analysis. See details.}
  \item{fixed.cov}{A character vector with the names of the covariates that will be considered as fixed (no variable selection over these). This argument provides an implicit definition of the simplest model considered. Default is "Intercept". Use NULL if selection should be performed over all the variables defined by \code{formula}}
  \item{data }{data frame containing the data.}
  \item{prior.betas }{Prior distribution for regression parameters within each model. Possible choices include "Robust", "Liangetal", "gZellner", "ZellnerSiow" and "FLS"  (see details)}
  \item{prior.models }{Prior distribution over the model space. Possible choices are "Constant" and "ScottBerger" and "User" (see details)}
  \item{n.keep }{How many of the most probable models are to be kept?}
  \item{n.nodes }{Number of nodes to be used in the computation}
  \item{priorprobs}{A p+1 dimensional vector defining the prior probabilities Pr(M_i) (should be used in the case where \code{prior.models}="User"; see details.)}
  \item{time.test }{If TRUE a preliminary test to estimate computational time is performed.}
  
}
\details{
This function takes advantage of the library \code{parallel} to distribute the models in the model space
throughout the number of nodes available. Its intended use is for moderately large model spaces (p>=20).

A detailed description of the arguments can be found in the details section in \code{\link[BayesVarSel]{Bvs}}.
}
\value{\code{PBvs} returns an object of class \code{Bvs} with the following elements:
\item{time }{The internal time consumed in solving the problem}
\item{lmfull }{The \code{lm} class object that results when the model defined by \code{formula} is fitted by \code{lm}}
\item{lmnull }{The \code{lm} class object that results when the model defined by \code{fixed.cov} is fitted by \code{lm}}
\item{variables }{The name of all the potential explanatory variables (the set of variables to select from).}
\item{n }{Number of observations}
\item{p }{Number of explanatory variables to select from}
\item{k }{Number of fixed variables}
\item{HPMbin }{The binary expression of the Highest Posterior Probability model}
\item{modelsprob }{A \code{data.frame} which summaries the \code{n.keep} most probable, a posteriori models, and their associated probability.}
\item{inclprob }{A \code{data.frame} with the inclusion probabilities of all the variables.}
\item{jointinclprob }{A \code{data.frame} with the joint inclusion probabilities of all the variables.}
\item{postprobdim }{Posterior probabilities of the dimension of the true model}
\item{call }{The \code{call} to the function}
\item{method }{\code{parallel}} 
}
\author{
Gonzalo Garcia-Donato and Anabel Forte

Maintainer: <anabel.forte@uv.es>
}
\references{

  Bayarri, M.J., Berger, J.O., Forte, A. and Garcia-Donato, G. (2012)<DOI:10.1214/12-aos1013> Criteria for Bayesian Model choice with Application to Variable Selection. The Annals of Statistics. 40: 1550-1557

  Fernandez, C., Ley, E. and Steel, M.F.J. (2001)<DOI:10.1016/s0304-4076(00)00076-2> Benchmark priors for Bayesian model averaging. Journal of Econometrics, 100, 381-427.
  
  Liang, F., Paulo, R., Molina, G., Clyde, M. and  Berger, J.O. (2008)<DOI:10.1198/016214507000001337> Mixtures of  g-priors for Bayesian Variable Selection. Journal of the American Statistical Association. 103:410-423.
  
  Zellner, A. and Siow, A. (1980)<DOI:10.1007/bf02888369>  Posterior Odds Ratio for Selected Regression Hypotheses. In Bayesian Statistics 1 (J.M. Bernardo, M. H. DeGroot, D. V. Lindley and A. F. M. Smith, eds.) 585-603. Valencia: University Press. 
  
  Zellner, A. and Siow, A. (1984). Basic Issues in Econometrics. Chicago: University of
Chicago Press.
 
  Zellner, A. (1986)<DOI:10.2307/2233941> On Assessing Prior Distributions and Bayesian Regression Analysis with g-prior Distributions. In Bayesian Inference and Decision techniques: Essays in Honor of Bruno de Finetti (A. Zellner, ed.) 389-399. Edward Elgar Publishing
Limited. 

}

\keyword{ package }
\seealso{
\code{\link[BayesVarSel]{plotBvs}} for different descriptive plots of the results, \code{\link[BayesVarSel]{BMAcoeff}} for obtaining model averaged simulations of regression coefficients and \code{\link[BayesVarSel]{predictBvs}} for predictions.


\code{\link[BayesVarSel]{GibbsBvs}} which implements a heuristic approximation to the problem based on Gibbs sampling.
}

\examples{
\dontrun{
#Analysis of Crime Data
#load data

data(UScrime)

#Default arguments are Robust prior for the regression parameters
#and constant prior over the model space
#Here we keep the 1000 most probable models a posteriori:
#The computation over the model space is distributed over two
#cores:
crime.Bvs<- PBvs(formula= y ~ . , data = UScrime, n.keep = 1000, 
n.nodes = 2)

#A look at the results:
crime.Bvs

summary(crime.Bvs)

#An image plot with the joint inlcusion 
#probabilities:
plotBvs(crime.Bvs, option="joint")
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
