% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotManhattan.R
\name{plotManhattan}
\alias{plotManhattan}
\title{plot Manhattan-like plots for marginal posterior inclusion probabilities (mPIP) and numbers of responses of association for predictors}
\usage{
plotManhattan(
  x,
  which = c(1, 2),
  x.loc = FALSE,
  axis.label = "auto",
  mark.responses = NULL,
  xlab1 = "Predictors",
  ylab1 = "mPIP",
  xlab2 = "Predictors",
  ylab2 = "No. of responses",
  threshold = 0.5,
  las = 0,
  cex.axis = 1,
  mark.pos = c(0, 0),
  mark.color = 2,
  mark.cex = 0.8,
  header = "",
  ...
)
}
\arguments{
\item{x}{an object of class \code{BayesSUR}}

\item{which}{if it's value "1" showing the Manhattan-like plot of the marginal posterior inclusion probabilities (mPIP). If it's value "2" showing the Manhattan-like plot of the number of responses. The default is to show both figures.}

\item{x.loc}{a vector of features distance}

\item{axis.label}{a vector of predictor names which are shown in the Manhattan-like plot. The value "NULL" only showing the indices. The default "auto" show the predictor names from the orginal data.}

\item{mark.responses}{a vector of response names which are shown in the Manhattan-like plot for the mPIP}

\item{xlab1}{a title for the x axis of Manhattan-like plot for the mPIP}

\item{ylab1}{a title for the y axis of Manhattan-like plot for the mPIP}

\item{xlab2}{a title for the x axis of Manhattan-like plot for the numbers of responses}

\item{ylab2}{a title for the y axis of Manhattan-like plot for the numbers of responses}

\item{threshold}{threshold for showing number of response variables significantly associated with each feature}

\item{las}{graphical parameter of plot.default}

\item{cex.axis}{graphical parameter of plot.default}

\item{mark.pos}{the location of the marked text relative to the point}

\item{mark.color}{the color of the marked text. The default color is red.}

\item{mark.cex}{the fontsize of the marked text. The default fontsize is 0.8.}

\item{header}{the main title}

\item{...}{other arguments}
}
\description{
Plot Manhattan-like plots for marginal posterior inclusion probabilities (mPIP) and numbers of responses of association for predictors of a "BayesSUR" class object.
}
\examples{
data("exampleEQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

set.seed(9173)
fit <- BayesSUR(Y = exampleEQTL[["blockList"]][[1]], 
                X = exampleEQTL[["blockList"]][[2]],
                data = exampleEQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/" )

## check output
# show the Manhattan-like plots
plotManhattan(fit)

}
