% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary.bsim}
\alias{summary.bsim}
\alias{print.summary.bsim}
\title{Summarize \code{BayesSIM}}
\usage{
\method{summary}{bsim}(object, ...)

\method{print}{summary.bsim}(x, digits = 3, ...)
}
\arguments{
\item{object}{A fitted object of \code{BayesSIM} or individual model.}

\item{...}{Further arguments passed.}

\item{x}{A summary output of \code{BayesSIM} or individual model.}

\item{digits}{The minimum number of significant digits to be printed.}
}
\value{
The function summarizes posterior MCMC samples by reporting key statistics, including:
\itemize{
\item Posterior mean and median
\item Empirical standard deviation
\item 95\% credible interval (lower and upper quantiles)
\item Potential scale reduction factor (\code{gelman}) for multiple chains
\item Effective sample size (\code{ESS})
}

By default, the index vector and error variance are only included in the summary.
If variable selection methods are used, such as uniform sphere and spike-and-slab prior,
the indicator vector (\code{nu}) is also included.
Note that the potential scale reduction factor for \code{nu} can be reported as
\code{NaN} or \code{Inf}, since the indicator rarely changes during the MCMC run.

If the model is fitted with single chain, both \code{all.chain} and \code{chain} have identical information.
}
\description{
Provides a \code{summary} for \code{BayesSIM}.
}
\details{
A \code{list} of summary statistics for MCMC samples, including \code{data.frame} table for the results.
Each row corresponds to a model parameter, and columns report the statistics.
}
\examples{
\donttest{
simdata2 <- data.frame(DATA1$X, y = DATA1$y)

# 1. One tool version
fit_one <- BayesSIM(y ~ ., data = simdata2,
                    niter = 5000, nburnin = 1000, nchain = 1)

# Check median index vector estimates with standard errors
coef(fit_one, method = "median", se = TRUE)

# Fitted index values of median prediction
fitted(fit_one, type = "linpred", method = "median")

# Residuals of median prediction
residuals(fit_one, method = "median")

# Summary of the model
summary(fit_one)

# Convergence diagnostics
nimTraceplot(fit_one)

# Goodness of fit
GOF(fit_one)

# Fitted plot
plot(fit_one)

# Prediction with 95\% credible interval at new data
newx <- data.frame(X1 = rnorm(10), X2 = rnorm(10), X3 = rnorm(10), X4 = rnorm(10))
pred <- predict(fit_one, newdata = newx, interval = "credible", level = 0.95)
plot(pred)


# 2. Split version
models <- BayesSIM_setup(y ~ ., data = simdata2)
Ccompile <- compileModelAndMCMC(models)
nimSampler <- get_sampler(Ccompile)
initList <- getInit(models)
mcmc.out <- runMCMC(nimSampler, niter = 5000, nburnin = 1000, thin = 1,
                    nchains = 1, setSeed = TRUE, inits = initList,
                    summary = TRUE, samplesAsCodaMCMC = TRUE)

# "fit_split" becomes exactly the same as the class of "fit_one" object and apply generic functions.
fit_split <- as_bsim(models, mcmc.out)

}

}
\seealso{
\code{\link[coda]{gelman.diag}}, \code{\link[coda]{effectiveSize}}
}
