% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_blc.R
\name{Heatmap.BLC}
\alias{Heatmap.BLC}
\title{Draw a Heat Map for BLC or PredBLC fitted models}
\usage{
\method{Heatmap}{BLC}(x, x_lab = NULL, age = NULL, color = c("red", "white", "blue"), ...)
}
\arguments{
\item{x}{A \code{BLC} or \code{PredBLC} object, result of a call to blc() function or forecast via predict() function.}

\item{x_lab}{Description of the modelled object.}

\item{age}{Vector with the ages to plot the heatmap.}

\item{color}{Vector of colours used in the heatmap.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A ggplot2 heatmap of the life expectancy.
}
\description{
Draws a Heat Map based on the life expectancy of a fitted BLC or PredBLC model.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model

fit = blc(Y = Y, numit = 100, warmup = 20)

## Heatmap:
Heatmap(fit, x_lab = 2000:2015, age = 18:80)

}
\seealso{
\code{\link[=Heatmap.HP]{Heatmap.HP()}} and \code{\link[=Heatmap.DLM]{Heatmap.DLM()}} for \code{HP} or \code{DLM} methods.
}
