% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_posterior_intervals.R
\name{compute_posterior_intervals.BayesMallows}
\alias{compute_posterior_intervals.BayesMallows}
\title{Compute posterior intervals}
\usage{
\method{compute_posterior_intervals}{BayesMallows}(
  model_fit,
  burnin = model_fit$burnin,
  parameter = "alpha",
  level = 0.95,
  decimals = 3L,
  ...
)
}
\arguments{
\item{model_fit}{An object of class \code{BayesMallows} returned from
\code{\link{compute_mallows}}.}

\item{burnin}{A numeric value specifying the number of iterations to discard
as burn-in. Defaults to \code{model_fit$burnin}, and must be provided if
\code{model_fit$burnin} does not exist. See
\code{\link{assess_convergence}}.}

\item{parameter}{Character string defining which parameter to compute
posterior intervals for. One of \code{"alpha"}, \code{"rho"}, or
\code{"cluster_probs"}. Default is \code{"alpha"}.}

\item{level}{Decimal number in \eqn{[0,1]} specifying the confidence level.
Defaults to \code{0.95}.}

\item{decimals}{Integer specifying the number of decimals to include in
posterior intervals and the mean and median. Defaults to \code{3}.}

\item{...}{Other arguments. Currently not used.}
}
\description{
Compute posterior intervals
}
\seealso{
assess_convergence

Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus.BayesMallows}()},
\code{\link{compute_consensus.SMCMallows}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals.SMCMallows}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallowsMixtures}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
