% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smc_post_processing_functions.R
\name{compute_posterior_intervals_alpha}
\alias{compute_posterior_intervals_alpha}
\title{Compute Posterior Intervals Alpha}
\usage{
compute_posterior_intervals_alpha(output, nmc, burnin, verbose = FALSE)
}
\arguments{
\item{output}{a subset of an SMCMallows object (though technically any numeric vector will do)}

\item{nmc}{Number of Monte Carlo samples}

\item{burnin}{A numeric value specifying the number of iterations
to discard as burn-in.}

\item{verbose}{if \code{TRUE}, prints the final output even if the function
is assigned to an object. Defaults to \code{FALSE}.}
}
\description{
posterior confidence intervals
}
\examples{
# Basic elements
data <- sushi_rankings[1:100, ]
n_items <- ncol(data)
leap_size <- floor(n_items / 5)
metric <- "footrule"
Time <- 20
N <- 100

# Prepare exact partition function
cardinalities <- prepare_partition_function(metric = metric,
                                            n_items = n_items)$cardinalities

# Performing SMC
smc_test <- smc_mallows_new_users(
  R_obs = data, type = "complete", n_items = n_items,
  metric = metric, leap_size = leap_size,
  N = N, Time = Time,
  cardinalities = cardinalities,
  mcmc_kernel_app = 5,
  num_new_obs = 5,
  alpha_prop_sd = 0.5,
  lambda = 0.15,
  alpha_max = 1e6
)

test_sample_rho <- smc_test$rho_samples[, , Time + 1]
compute_posterior_intervals_rho(
  output = test_sample_rho,
  nmc = N, burnin = 0,
  verbose = FALSE
)

compute_rho_consensus(
  output = test_sample_rho, nmc = N,
  burnin = 0, C = 1, type = "CP",
  verbose = FALSE
)

test_sample_alpha <- smc_test$alpha_samples[, Time + 1]
compute_posterior_intervals_alpha(
  output = test_sample_alpha,
  nmc = N, burnin = 0, verbose = FALSE
)
}
\seealso{
\code{\link{smc_mallows_new_item_rank}} and
\code{\link{smc_mallows_new_users}}, which are functions generating objects
of SMCMallows class.
}
\author{
Anja Stein
}
