% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgwqs.fit.R
\name{bgwqs.fit}
\alias{bgwqs.fit}
\title{Bayesian Grouped WQS Regression}
\usage{
bgwqs.fit(
  y,
  x,
  z = NULL,
  x.s,
  n.quantiles = 4,
  working.dir,
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  debug = FALSE
)
}
\arguments{
\item{y}{A vector containing outcomes.}

\item{x}{A matrix of component data.}

\item{z}{A vector or matrix of covariates.}

\item{x.s}{A vector of the number of components in each index.}

\item{n.quantiles}{The number of quantiles to apply to the component data.}

\item{working.dir}{A file path to the directory.}

\item{n.iter}{The number of total iterations per chain, including burn in.}

\item{n.burnin}{The number of iterations to discard at the beginning.}

\item{n.thin}{The thinning rate, which must be a positive integer.}

\item{debug}{False by default, when true OpenBUGS remains open for further investigation.}
}
\value{
A list of 3 which includes the BUGS output, coda output, and convergence test results.
}
\description{
This function fits a Bayesian grouped weighted quantile sum (BGWQS) regression model.
}
\examples{
\donttest{
data("simdata")
group_list <- list(c("pcb_118", "pcb_138", "pcb_153", "pcb_180", "pcb_192"),
                   c("as", "cu", "pb", "sn"),
                   c("carbaryl", "propoxur", "methoxychlor", "diazinon", "chlorpyrifos"))
x.s <- make.x.s(simdata, 3, group_list)
X <- make.X(simdata, 3, group_list)
Y <- simdata$Y
work_dir <- tempdir()
results <- bgwqs.fit(y = Y, x = X, x.s = x.s, n.quantiles=4, working.dir = work_dir,
                    n.iter = 10000, n.burnin = 5000, n.thin = 1)
}

}
