% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.plot.curves}
\alias{GP.plot.curves}
\title{Graphical representation of multiple curves in one and two-dimensional
curves}
\usage{
GP.plot.curves(
  curves,
  xlab = NULL,
  ylab = NULL,
  cols = NULL,
  lwd = NULL,
  type = NULL,
  leg_pos = NULL,
  xlim = NULL,
  ylim = NULL,
  col.regions = NULL,
  cut = NULL,
  ...
)
}
\arguments{
\item{curves}{A list object of multiple curves and each curve is a list with two elements:
\describe{
 \item{f}{A vector of real numbers for the curve.}
 \item{x}{A matrix of real numbers for the grid points where rows are observations and columns are coordinates.}
}}

\item{xlab}{A character specifying the label of x-axis for 1D, 2D and 3D case. The default value is NULL and set to "x" for 1D case and "x1" for 2D case.}

\item{ylab}{A character specifying the label of y-axis for 1D curve or coords for 2D and 3D case.  The default value is NULL and set to "x2" for 2D case.}

\item{cols}{A vector of integer numbers or characters to specify the plot colors for 1D curve. The default value is NULL and set to 1:length(curves).}

\item{lwd}{A positive number to specify the width of lines for 1D curve.}

\item{type}{A character specifying what type of plot should be drawn for 1D curve. Possible types are the same as \link{plot}.}

\item{leg_pos}{A character spaecifying the position of legend for multiple 1D curves. Possible valeus are "topleft", "topright","bottemright","bottemleft".}

\item{xlim}{A vector of two real numbers specifying the range of x-axis for 1D, 2D and 3D case. The default value is NULL and set to range(curve$x[,1]).}

\item{ylim}{A vector of two real numbers specifying the range of y-axis only for 2D, 3D case. The default value is NULL and set to range(curve$x[,2]).}

\item{col.regions}{A vector of RGB colors for 2D and 3D plots. See \link{GP.create.cols}. The default value is NULL and set to GP.create.cols().}

\item{cut}{An integer specifying the number of colors in 2D  plots. The default value is NULL and set to length(col.regions)-1.}

\item{...}{All other parameters for plot (1D case) and levelplot (2D case).}
}
\value{
NULL for 1D case. An object of class "trellis" for 2D and 3D cases.
}
\description{
Graphical representation of multiple curves in one and two-dimensional
curves
}
\examples{
library(BayesGPfit)
library(lattice)
set.seed(1227)
dat = list()
dat$x = GP.generate.grids(d=2L,num_grids = 100)
curve = GP.simulate.curve.fast(dat$x,a=0.01,b=0.5,poly_degree=20L)
dat$f = curve$f + rnorm(length(curve$f),sd=1)
fast_fit = GP.fast.Bayes.fit(dat$f,dat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
reg_fit = GP.Bayes.fit(dat$f,dat$x,a=0.01,b=0.5,poly_degree=20L,progress_bar = TRUE)
curves = list(True = curve,
Bayes_fast = fast_fit,
Bayes = reg_fit)
GP.plot.curves(curves,
              main="Comparisons of Bayesian model fitting")

}
\author{
Jian Kang <jiankang@umich.edu>
}
