\name{DS.macro.inf}
\alias{DS.macro.inf}
\alias{Local.Mode}
\alias{plot.DS_GF_macro_mean}
\alias{plot.DS_GF_macro_mode}
\alias{print.DS_GF_macro_mean}
\alias{print.DS_GF_macro_mode}
\alias{DS.GF.macro.obj}
\title{
Execute MacroInference (mean or mode) on a DS object
}
\description{
A function that combines several related, but potentially heterogeneous, studies to develop a more precise estimate of the overall distribution.}
\usage{
DS.macro.inf(DS.GF.obj, num.modes = 1, iters = 500, method = c("mean", "mode"))
}

\arguments{
  \item{DS.GF.obj}{Object from \code{DS.prior}}
  \item{num.modes}{The total number of modes expected based on results from \code{DS.prior}}
  \item{iters}{Integer value of total number of iterations}
  \item{method}{\code{mean} returns mean value and standard error of the distribution; \code{mode} returns value and standard error of each mode}
  }
\details{
Through \code{method}, user determines overall estimate as either the \code{mean} or \code{mode}.}
\value{
  \item{DS.GF.macro.obj}{object of class \code{DS.GF.macro} associated with either mean or mode}
  \item{model.modes}{Given method \code{mode}, values of \eqn{\theta} for the modes of DS prior generated by object}
  \item{mode.sd}{Given method \code{mode}, vector that provides the bootstrapped standard error for each mode}
  \item{prior.data}{Given either method, dataframe of the prior data, imported from the \code{DS.prior} object}
  \item{boot.modes}{Given method \code{mode}, vector of modes derived from bootstrapping}
  \item{model.mean}{Given method \code{mean}, value of \eqn{\theta} for the mean of the distribution}
  \item{mean.sd}{Given method \code{mean}, bootstrapped standard error for the mean}
  \item{boot.mean}{Given method \code{mean}, bootstrapped mean for the distribution}
}
\references{
Mukhopadhyay, S. and Fletcher, D. (2017), "Bayes Modeling via Goodness of Fit," Technical report.
}
\author{Doug Fletcher, Subhadeep Mukhopadhyay}
\examples{
\dontrun{
### MacroInference: Mode
data(rat)
rat.start <- BetaBinoMLE(rat$y, rat$n)$estimate
rat.ds <- DS.prior(rat, max.m = 4, rat.start)
rat.ds.macro <- DS.macro.inf(rat.ds, num.modes = 2, method = "mode", iters = 5)
rat.ds.macro
plot(rat.ds.macro)
### MacroInference: Mean
data(terb)
terb.start <- BetaBinoMLE(terb$y, terb$n)$estimate
terb.ds <- DS.prior(terb, max.m = 2, terb.start)
terb.ds.macro <- DS.macro.inf(terb.ds, num.modes = 1, method = "mean", iters = 5)
terb.ds.macro
plot(terb.ds.macro)}
}
\keyword{DS Main Functions}


