\name{CPPpriorSample}
\alias{CPPpriorSample}
\title{Function to Sample Hazard Rates from CPP Priors}
\description{A function to generate a random sample of hazard rates from a CPP prior distribution.}
\usage{CPPpriorSample(ss = 1, hyp = CPPpriorElicit())}
\arguments{
  \item{ss}{requested sample size}
  \item{hyp}{list of hyperparameters (as generated by \code{\link{CPPpriorElicit}})}
}
\details{A random sample of \code{ss} hazard rates is extracted from the CPP prior distribution identified by \code{hyp}.}
\value{
A list with four components:
  \item{hyp}{list of hyperparameters identifying the CPP prior distribution
                    from which the sample was extracted (copy of the input argument)}
  \item{sgm}{matrix with \code{ss} rows (and \code{hyp$F} columns) containing the CPP jump-times}
  \item{xi0}{matrix with \code{ss} rows (and just one column) containing the jump-sizes in the origin}
  \item{csi}{matrix with \code{ss} rows (and \code{hyp$F} columns) containing the CPP jump-sizes}
}
\seealso{\code{\link{CPPevalHR}}, \code{\link{CPPplotHR}}}
\examples{
# set RNG seed (for example reproducibility only)
set.seed(1234)

# select a CPP prior distribution
hypars<-CPPpriorElicit(r0 = 0.1, H = 1, T00 = 50, M00 = 2)

# generate a sample of ten hazard rates
prior<-CPPpriorSample(ss = 10, hyp = hypars)
}
\keyword{distribution}
\keyword{survival}
\keyword{smooth}
