\name{makeSubmitJobResult}
\alias{SubmitJobResult}
\alias{makeSubmitJobResult}
\title{Create a SubmitJobResult object.}
\usage{
makeSubmitJobResult(status, batch.job.id, msg, ...)
}
\arguments{
  \item{status}{[\code{integer(1)}]\cr Launch status of
  job.  0 means success, codes bewteen 1 and 100 are
  temporary errors and any error greater than 100 is a
  permanent failure.}

  \item{batch.job.id}{[\code{character(1)}]\cr Unique id of
  this job on batch system. Note that this is not the usual
  job id used in BatchJobs!  Must be globally unique so
  that the job can be terminated using just this
  information.}

  \item{msg}{[\code{character(1)}]\cr Optional error
  message in case \code{status} is not equal to 0.  Default
  is \dQuote{OK}, \dQuote{TEMPERR}, \dQuote{ERROR},
  depending on \code{status}.}

  \item{...}{[\code{any}]\cr Currently unused.}
}
\value{
[\code{\link{SubmitJobResult}}]. A list, containing
\code{status}, \code{batch.job.id} and \code{msg}.
}
\description{
Use this function in your implementation of
\code{\link{makeClusterFunctions}} to create a return value
for the \code{submitJob} function.
}

