% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.data.R
\name{checkerboard}
\alias{checkerboard}
\title{Generate data for an example of Zhu, Zeng and Kosorok (2015)}
\usage{
checkerboard(n, p, sigma, binary)
}
\arguments{
\item{n}{The number of observations.}

\item{p}{The number of predictors.}

\item{sigma}{The error variance.}

\item{binary}{A boolean argument: \code{binary = TRUE} indicates that binary responses are generated and \code{binary = FALSE} 
indicates that continuous responses are generated.}
}
\value{
Return a list with the following components.
\item{X}{An n by p data frame representing predictors values, with each row corresponding an observation.}
\item{Y}{A vector of length n representing response values.}
\item{f0}{A vector of length n representing the values of \eqn{f0(x)}.}
\item{sigma}{The error variance which is only returned when \code{binary = FALSE}.}
\item{prob}{A vector of length n representing the values of \eqn{\Phi(f0(x))}, which is only returned when \code{binary = TRUE}.}
}
\description{
Generate data including responses and predictors values according to an example of Zhu, R., Zeng, D. and Kosorok, M. R. (2015). 
"Reinforcement learning trees." \emph{J. Amer. Statist. Assoc.} \strong{110} 1770--1784.
}
\details{
Sample the predictors \eqn{x_1, ..., x_p} from Normal(\eqn{0, \Sigma}) with \eqn{\Sigma_{jk} = 0.3^{|j-k|}}, \eqn{j,k = 1, ..., p}.
If \code{binary = FALSE}, sample the continuous response \eqn{y} from Normal(\eqn{f0(x), \sigma^2}), where 
\deqn{f0(x) = 2x_1*x_4 + 2x_7*x_{10}.}
If \code{binary = TRUE}, sample the binary response \eqn{y} from Bernoulli(\eqn{\Phi(f0(x))}) where \eqn{f0} is defined above and
 \eqn{\Phi} is the cumulative density function of the standard normal distribution.
}
\examples{
data = checkerboard(100, 10, 1, FALSE)
}
\references{
Luo, C. and Daniels, M. J. (2021)
  "Variable Selection Using Bayesian Additive Regression Trees."
  \emph{arXiv preprint arXiv:2112.13998}.
  
Zhu, R., Zeng, D. and Kosorok, M. R. (2015). 
  "Reinforcement learning trees." 
  \emph{J. Amer. Statist. Assoc.} \strong{110} 1770--1784.
}
\author{
Chuji Luo: \email{cjluo@ufl.edu} and Michael J. Daniels: \email{daniels@ufl.edu}.
}
