% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Substance.R
\docType{class}
\name{Substance-class}
\alias{Substance-class}
\title{Structure of the S4 class "Substance"}
\description{
Structure of the S4 class \code{Substance} representing substances in the environment which can be produced or consumed.
}
\section{Slots}{

\describe{
\item{\code{smax}}{A number representing the start concentration of the substance for each grid cell in the environment.}

\item{\code{diffmat}}{A sparse matrix containing all concentrations of the substance in the environment.}

\item{\code{name}}{A character vector representing the name of the substance.}

\item{\code{id}}{A character vector representing the identifier of the substance.}

\item{\code{difunc}}{A character vector ("pde","cpp" or "r") describing the function for diffusion.}

\item{\code{difspeed}}{A number indicating the diffusion rate (given by cm^2/h). Default is set to glucose diffusion in a aqueous solution (6.7e-6 cm^2/s * 3600 s/h = 0.02412 cm^2/h ).}

\item{\code{advspeed}}{A number indicating the advection rate in x direction (given by cm/h).}

\item{\code{diffgeometry}}{Diffusion coefficient defined on all grid cells (initially set by constructor).}

\item{\code{pde}}{Choose diffusion transport reaction to be used (default is diffusion only)}

\item{\code{boundS}}{A number defining the attached amount of substance at the boundary (Warning: boundary-function must be set in pde!)}
}}

