% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\docType{methods}
\name{constrain}
\alias{constrain}
\alias{constrain,Organism-method}
\title{Function for constraining the models based on metabolite concentrations}
\usage{
constrain(object, reacts, lb, ub, dryweight, tstep, scale, j)

\S4method{constrain}{Organism}(object, reacts, lb, ub, dryweight, tstep, scale,
  j)
}
\arguments{
\item{object}{An object of class Organisms.}

\item{reacts}{A character vector giving the names of reactions which should be constrained.}

\item{lb}{A numeric vector giving the constraint values of lower bounds (e.g. avaible metabolite concentrations}

\item{ub}{A numeric vector giving the constraint values of upper bounds.}

\item{dryweight}{A number giving the current dryweight of the organism.}

\item{tstep}{A number giving the time intervals for each simulation step.}

\item{scale}{A numeric defining the scaling (units for linear programming has to be in certain range)}

\item{j}{debuging index to track cell}
}
\value{
Returns the lower bounds, which carry the constraints and names of relevant reactions.
}
\description{
The generic function \code{constrain} changes the constraints of the model representation of an organism.
}
\details{
The constraints are calculated according to the flux definition as mmol/(gDW*hr) with the parameters \code{dryweight} and \code{tstep}.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
org <- Organism(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize an organism
lobnds <- constrain(org,org@medium,org@lbnd[org@medium],1,1,1,1,1)
}
\seealso{
\code{\link{Organism-class}}
}
