% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\docType{methods}
\name{findInArena}
\alias{findInArena}
\alias{findInArena,Arena-method}
\title{Function for searching a keyword in arena organisms and media}
\usage{
findInArena(object, pattern, search_rea = TRUE, search_sub = TRUE)

\S4method{findInArena}{Arena}(object, pattern, search_rea = TRUE,
  search_sub = TRUE)
}
\arguments{
\item{object}{An object of class Arena.}

\item{pattern}{A pattern for searching}

\item{search_rea}{Only search for reactions}

\item{search_sub}{Only search for substances}
}
\description{
The generic function \code{findInArena} tries to find information (e.g. full names) about a specific keyword
}
\examples{
data(Ec_core)
bac <- Bac(Ec_core)
arena <- Arena(n=20,m=20)
arena <- addOrg(arena,bac,amount=10)
findInArena(arena, "acetate")
}

