% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/68_irf_plot.R
\name{plot.bvar_irf}
\alias{plot.bvar_irf}
\title{Plotting method for Bayesian VAR impulse responses}
\usage{
\method{plot}{bvar_irf}(
  x,
  vars_response = NULL,
  vars_impulse = NULL,
  col = "#737373",
  area = FALSE,
  fill = "#808080",
  variables = NULL,
  mar = c(2, 2, 2, 0.5),
  ...
)
}
\arguments{
\item{x}{A \code{bvar_irf} object, obtained from \code{\link{irf.bvar}}.}

\item{vars_impulse, vars_response}{Optional numeric or character vector. Used
to subset the plot's impulses / responses to certain variables by position
or name (must be available). Defaults to \code{NULL}, i.e. all variables.}

\item{col}{Character vector. Colour(s) of the lines delineating credible
intervals. Single values will be recycled if necessary. Recycled HEX color
codes are varied in transparency if not provided (e.g. "#737373FF"). Lines
can be bypassed by setting this to \code{"transparent"}.}

\item{area}{Logical scalar. Whether to fill the credible intervals using
\code{\link[graphics]{polygon}}.}

\item{fill}{Character vector. Colour(s) to fill the credible intervals with.
See \emph{col} for more information.}

\item{variables}{Optional character vector. Names of all variables in the
object. Used to subset and title. Taken from \code{x$variables} if available.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns \emph{x} invisibly.
}
\description{
Plotting method for impulse responses obtained from \code{\link{irf.bvar}}.
Impulse responses of all or a subset of the available variables can be
plotted.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 1000L, n_burn = 200L, verbose = FALSE)

# Store IRFs ex-post
irf(x) <- irf(x)

# Plot impulse responses for all available variables
plot(irf(x))

# Subset to impulse variables in positions 2 and 3 via their name
plot(irf(x), vars_impulse = c(2, 3))

# Subset via position and increase the plotted IRF horizon
plot(irf(x, horizon = 20), vars_impulse = c("UNRATE", "FED"))

# Adjust confidence bands and subset to one response variables
plot(irf(x, conf_bands = 0.25), vars_response = "CPI")

# Draw areas inbetween the confidence bands and skip drawing lines
plot(irf(x), col = "transparent", area = TRUE)

# Subset to a specific impulse and response
plot(irf(x), vars_response = "CPI", vars_impulse = "FED")
}
}
\seealso{
\code{\link{bvar}}; \code{\link{irf.bvar}}
}
\keyword{BVAR}
\keyword{analysis}
\keyword{fevd}
\keyword{irf}
\keyword{plot}
