% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/80_coda.R
\name{coda}
\alias{coda}
\alias{as.mcmc.bvar}
\alias{as.mcmc.bvar_chains}
\title{Methods for \pkg{coda} Markov chain Monte Carlo objects}
\usage{
as.mcmc.bvar(
  x,
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  ...
)

as.mcmc.bvar_chains(
  x,
  vars = NULL,
  vars_response = NULL,
  vars_impulse = NULL,
  chains = list(),
  ...
)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{vars}{Character vector used to select variables. Elements are matched
to hyperparameters or coefficients. Coefficients may be matched based on
the dependent variable (by providing the name or position) or the
explanatory variables (by providing the name and the desired lag). See the
example section for a demonstration. Defaults to \code{NULL}, i.e. all
hyperparameters.}

\item{vars_response, vars_impulse}{Optional character or integer vectors used
to select coefficents. Dependent variables are specified with
\emph{vars_response}, explanatory ones with \emph{vars_impulse}. See the
example section for a demonstration.}

\item{chains}{List with additional \code{bvar} objects. If provided,
an object of class \code{\link[coda]{mcmc.list}} is returned.}

\item{...}{Other parameters for \code{\link[coda]{as.mcmc}}.}
}
\value{
Returns a \pkg{coda} \code{\link[coda]{mcmc}} (or
\code{\link[coda]{mcmc.list}}) object.
}
\description{
Methods to convert parameter and/or coefficient draws from \code{\link{bvar}}
to \pkg{coda}'s \code{\link[coda]{mcmc}} (or \code{\link[coda]{mcmc.list}})
format for further processing.
}
\examples{
\donttest{
library("coda")

# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate two BVARs using one lag, default settings and very few draws
x <- bvar(data, lags = 1, n_draw = 750L, n_burn = 250L, verbose = FALSE)
y <- bvar(data, lags = 1, n_draw = 750L, n_burn = 250L, verbose = FALSE)

# Convert the hyperparameter lambda
as.mcmc(x, vars = c("lambda"))

# Convert coefficients for the first dependent, use chains in method
as.mcmc(structure(list(x, y), class = "bvar_chains"), vars = "CPIAUCSL")

# Convert the coefs of variable three's first lag, use in the generic
as.mcmc(x, vars = "FEDFUNDS-lag1", chains = y)

# Convert hyperparameters and constant coefficient values for variable 1
as.mcmc(x, vars = "lambda", "CPI", "constant")

# Specify coefficent values to convert in alternative way
as.mcmc(x, vars_impulse = c("FED", "CPI"), vars_response = "UNRATE")
}
}
\seealso{
\code{\link{bvar}}; \code{\link[coda]{mcmc}};
\code{\link[coda]{mcmc.list}}
}
\keyword{BVAR}
\keyword{MCMC}
\keyword{analysis}
\keyword{coda}
