% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/94_logLik.R
\name{logLik.bvar}
\alias{logLik.bvar}
\title{Log-Likelihood method for Bayesian VARs}
\usage{
\method{logLik}{bvar}(object, ...)
}
\arguments{
\item{object}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\value{
Returns an object of class \code{logLik}.
}
\description{
Calculates the log-likelihood for Bayesian VARs generated with
\code{\link{bvar}}.
}
\examples{
\donttest{
data <- matrix(rnorm(200), ncol = 2)
x <- bvar(data, lags = 2)

# Get log-likelihood
logLik(x)
}
}
\seealso{
\code{\link{bvar}}
}
