% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/86_plot_irf.R
\name{plot.bvar_irf}
\alias{plot.bvar_irf}
\alias{bv_plot_irf}
\title{Impulse response plot}
\usage{
\method{plot}{bvar_irf}(x, conf_bands = 0.16, variables = NULL,
  vars_impulse = NULL, vars_response = NULL, mar = c(2, 2, 2, 0.5),
  ...)

bv_plot_irf(x, conf_bands = 0.16, variables = NULL,
  vars_impulse = NULL, vars_response = NULL, mar = c(2, 2, 2, 0.5),
  ...)
}
\arguments{
\item{x}{A \code{bvar} / \code{bvar_irf} object, obtained from
\code{\link{bvar}}.}

\item{conf_bands}{Numeric vector of desired confidence bands. E.g. for bands
at 5\%, 10\%, 90\% and 95\% set this to \code{c(0.05, 0.1)}.}

\item{variables}{Optional character vector. Names of all variables in the
object. Taken from \code{x$variables} if available.}

\item{vars_impulse}{Optional numeric or character vector. Used to subset the
plot's impulses to certain variables by position or name (\code{variables}
must be available). Defaults to \code{NULL}, i.e. all variables.}

\item{vars_response}{Optional numeric or character vector. Used to subset the
plot's responses to certain variables by position or name (\code{variables}
must be available). Defaults to \code{NULL}, i.e. all variables.}

\item{mar}{Numeric vector. Margins for \code{\link[graphics]{par}}.}

\item{...}{Other graphical parameters for \code{\link[graphics]{par}}.}
}
\description{
Plotting method for impulse responses obtained from \code{\link{bvar}}.
Impulse responses of all or a subset of the available variables can be
plotted.
}
\examples{
\donttest{
data <- matrix(rnorm(400), ncol = 4)
x <- bvar(data, lags = 2)

# Plot impulse responses for all available variables
bv_plot_irf(x)

# Subset to impulse variables in positions 2 and 4 via position and name
bv_plot_irf(x, vars_impulse = c(2, 4))

# Use the method to plot and adjust confidence bands
plot(x$irf, conf_bands = c(0.01, 0.05))
}
}
